/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.minio;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.minio")
public class MinioConfigurationProperties {
    private String url = "https://minio.dev.gomyck.com";
    private String accessKey = "admin";
    private String secretKey = "admin";
    private boolean secure = false;
    private String bucket;
    private String metricName = "minio.storage";
    private Duration connectTimeout = Duration.ofSeconds(10L);
    private Duration writeTimeout = Duration.ofSeconds(60L);
    private Duration readTimeout = Duration.ofSeconds(10L);
    private boolean checkBucket = true;
    private boolean createBucket = true;

    public String getUrl() {
        return this.url;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isCheckBucket() {
        return this.checkBucket;
    }

    public boolean isCreateBucket() {
        return this.createBucket;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setCheckBucket(boolean checkBucket) {
        this.checkBucket = checkBucket;
    }

    public void setCreateBucket(boolean createBucket) {
        this.createBucket = createBucket;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinioConfigurationProperties)) {
            return false;
        }
        MinioConfigurationProperties other = (MinioConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        if (this.isCheckBucket() != other.isCheckBucket()) {
            return false;
        }
        if (this.isCreateBucket() != other.isCreateBucket()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$metricName = this.getMetricName();
        String other$metricName = other.getMetricName();
        if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinioConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSecure() ? 79 : 97);
        result = result * 59 + (this.isCheckBucket() ? 79 : 97);
        result = result * 59 + (this.isCreateBucket() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $metricName = this.getMetricName();
        result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "MinioConfigurationProperties(url=" + this.getUrl() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", secure=" + this.isSecure() + ", bucket=" + this.getBucket() + ", metricName=" + this.getMetricName() + ", connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", readTimeout=" + this.getReadTimeout() + ", checkBucket=" + this.isCheckBucket() + ", createBucket=" + this.isCreateBucket() + ")";
    }
}

