/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.serialize.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gomyck.util.serialize.JSONAdapter;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FastJsonAdapter
implements JSONAdapter {
    private SerializerFeature[] serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat};
    private final SerializeConfig serializeConfig = new SerializeConfig();

    public FastJsonAdapter() {
        this.serializeConfig.put(Long.class, (jsonSerializer, o, o1, type, i) -> {
            if (Objects.isNull(o)) {
                jsonSerializer.write(null);
            } else {
                jsonSerializer.write(o.toString());
            }
        });
    }

    @Override
    public JSONAdapter prettyPrint() {
        this.serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.PrettyFormat};
        return this;
    }

    @Override
    public Object toJson(Object json) {
        if (json instanceof JSON) {
            return json;
        }
        String str = this.toJsonString(json);
        Object object = JSON.parse((String)str);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    @Override
    public Object toJsonMap(Object json) {
        return this.toJson(json);
    }

    @Override
    public <T> T parseObject(String jsonStr, Class<T> type) {
        return (T)JSON.parseObject((String)jsonStr, type);
    }

    @Override
    public String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).toJSONString();
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).toJSONString();
        }
        return JSON.toJSONString((Object)obj, (SerializeConfig)this.serializeConfig, (SerializerFeature[])this.serializerFeatures);
    }

    @Override
    public <T> List<T> parseArray(String jsonStr, Class<T> type) {
        return JSON.parseArray((String)jsonStr, type);
    }

    @Override
    public boolean isValid(String jsonStr) {
        if (JSON.isValid((String)jsonStr)) {
            return true;
        }
        return JSON.isValidArray((String)jsonStr);
    }

    @Override
    public Map<String, Object> parseMap(String jsonStr) {
        return (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public List<Map<String, Object>> parseListMap(String jsonStr) {
        return JSON.parseArray((String)jsonStr);
    }
}

