/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.serialize.adapter;

import com.gomyck.util.serialize.JSONAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class GsonAdapter
implements JSONAdapter {
    private Gson gson = new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).registerTypeAdapterFactory(new NullStringToEmptyAdapterFactory()).setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();

    @Override
    public JSONAdapter prettyPrint() {
        this.gson = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.STRING).setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).registerTypeAdapterFactory(new NullStringToEmptyAdapterFactory()).setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
        return this;
    }

    @Override
    public Object toJson(Object json) {
        if (json instanceof JsonElement) {
            return json;
        }
        return JsonParser.parseString((String)(json instanceof String ? json.toString() : this.toJsonString(json)));
    }

    @Override
    public Object toJsonMap(Object json) {
        if (json instanceof JsonElement) {
            return json;
        }
        try {
            return this.parseListMap(this.toJsonString(json));
        }
        catch (Exception e) {
            return this.parseMap(this.toJsonString(json));
        }
    }

    @Override
    public <T> T parseObject(String jsonStr, Class<T> type) {
        return (T)this.gson.fromJson(jsonStr, type);
    }

    @Override
    public String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        return this.gson.toJson(obj);
    }

    @Override
    public <T> List<T> parseArray(String jsonStr, Class<T> type) {
        Type _type = new TypeToken<List<T>>(){}.getType();
        return (List)this.gson.fromJson(jsonStr, _type);
    }

    @Override
    public boolean isValid(String jsonStr) {
        try {
            JsonParser.parseString((String)jsonStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, Object> parseMap(String jsonStr) {
        Type _type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)this.gson.fromJson(jsonStr, _type);
    }

    @Override
    public List<Map<String, Object>> parseListMap(String jsonStr) {
        Type _type = new TypeToken<List<Map<String, Object>>>(){}.getType();
        return (List)this.gson.fromJson(jsonStr, _type);
    }

    public static class StringNullAdapter
    extends TypeAdapter<String> {
        public String read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextString();
        }

        public void write(JsonWriter writer, String value) throws IOException {
            if (value == null) {
                writer.value("");
                return;
            }
            writer.value(value);
        }
    }

    public static class NullStringToEmptyAdapterFactory<T>
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (rawType == String.class) {
                return new StringNullAdapter();
            }
            return null;
        }
    }
}

