/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.serialize.adapter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.gomyck.util.serialize.JSONAdapter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JacksonAdapter
implements JSONAdapter {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonAdapter() {
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule timeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        this.mapper.registerModule((Module)timeModule);
        SimpleModule longModule = new SimpleModule();
        longModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        longModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        this.mapper.registerModule((Module)longModule);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new NullValueSerializer());
    }

    @Override
    public JSONAdapter prettyPrint() {
        this.mapper.writerWithDefaultPrettyPrinter();
        return this;
    }

    @Override
    public Object toJson(Object json) {
        String jsonStr = json instanceof String ? json.toString() : this.toJsonString(json);
        try {
            return this.mapper.readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object toJsonMap(Object json) {
        String jsonStr = json instanceof String ? json.toString() : this.toJsonString(json);
        try {
            return this.mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            try {
                return this.mapper.readValue(jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonProcessingException ex) {
                return json;
            }
        }
    }

    @Override
    public <T> T parseObject(String jsonStr, Class<T> type) {
        try {
            return (T)this.mapper.readValue(jsonStr, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> parseArray(String jsonStr, Class<T> type) {
        try {
            return (List)this.mapper.readValue(jsonStr, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isValid(String jsonStr) {
        try {
            this.mapper.createParser(jsonStr).canParseAsync();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Map<String, Object> parseMap(String jsonStr) {
        try {
            return (Map)this.mapper.readValue(jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Map<String, Object>> parseListMap(String jsonStr) {
        try {
            return (List)this.mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class NullValueSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Class<?> fieldType;
            String fieldName = gen.getOutputContext().getCurrentName();
            if (gen.getCurrentValue() == null) {
                gen.writeNull();
                return;
            }
            Class<?> clazz = gen.getCurrentValue().getClass();
            if (Map.class.isAssignableFrom(clazz)) {
                gen.writeNull();
                return;
            }
            try {
                fieldType = gen.getCurrentValue().getClass().getDeclaredField(fieldName).getType();
            }
            catch (NoSuchFieldException e) {
                throw new IOException(e);
            }
            if (String.class.isAssignableFrom(fieldType)) {
                gen.writeString("");
                return;
            }
            if (Collection.class.isAssignableFrom(fieldType)) {
                gen.writeStartArray();
                gen.writeEndArray();
                return;
            }
            if (Map.class.isAssignableFrom(fieldType)) {
                gen.writeStartObject();
                gen.writeEndObject();
                return;
            }
            gen.writeNull();
        }
    }
}

