/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.serialize.strategy;

import com.gomyck.util.serialize.JSONAdapter;
import com.gomyck.util.serialize.JSONType;
import com.gomyck.util.serialize.adapter.FastJsonAdapter;
import com.gomyck.util.serialize.adapter.GsonAdapter;
import com.gomyck.util.serialize.adapter.JacksonAdapter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public enum InitStrategy {
    FASTJSON2(1, "com.alibaba.fastjson2.JSONObject", JSONType.FASTJSON, FastJsonAdapter.class),
    GSON(2, "com.google.gson.Gson", JSONType.GSON, GsonAdapter.class),
    JACKSON(3, "com.fasterxml.jackson.databind.ObjectMapper", JSONType.JACKSON, JacksonAdapter.class);

    private final Integer orderNum;
    private final String className;
    private final JSONType jsonType;
    private final Class<? extends JSONAdapter> initClazz;

    private InitStrategy(Integer orderNum, String className, JSONType jsonType, Class<? extends JSONAdapter> initClazz) {
        this.orderNum = orderNum;
        this.className = className;
        this.jsonType = jsonType;
        this.initClazz = initClazz;
    }

    public static List<InitStrategy> getAll() {
        List<InitStrategy> result = Arrays.asList(InitStrategy.values());
        result.sort(Comparator.comparingInt(c -> c.orderNum));
        return result;
    }

    public Integer getOrderNum() {
        return this.orderNum;
    }

    public String getClassName() {
        return this.className;
    }

    public JSONType getJsonType() {
        return this.jsonType;
    }

    public Class<? extends JSONAdapter> getInitClazz() {
        return this.initClazz;
    }
}

