/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.spring.mvc.version;

import com.gomyck.util.servlet.TokenTake;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    private final double apiVersion;
    private static final String API_VERSION_HEADER_KEY = "apiVersion";

    public ApiVersionCondition(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    @NotNull
    public ApiVersionCondition combine(ApiVersionCondition other) {
        return new ApiVersionCondition(other.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(@NotNull HttpServletRequest request) {
        String apiVersion;
        if (request == null) {
            ApiVersionCondition.$$$reportNull$$$0(0);
        }
        if ((apiVersion = TokenTake.getToken(request, API_VERSION_HEADER_KEY)) == null) {
            return null;
        }
        double version = Double.parseDouble(apiVersion);
        if (version >= this.apiVersion) {
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionCondition other, @NotNull HttpServletRequest request) {
        if (request == null) {
            ApiVersionCondition.$$$reportNull$$$0(1);
        }
        return other.getApiVersion() - this.apiVersion > 0.0 ? 1 : -1;
    }

    public double getApiVersion() {
        return this.apiVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "request";
        objectArray2[1] = "com/gomyck/util/spring/mvc/version/ApiVersionCondition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchingCondition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

