/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.spring.schedule;

import com.gomyck.util.AutoConfig;
import com.gomyck.util.spring.schedule.CkScheduleInfo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@EnableScheduling
public class ScheduleAutoConfig
implements SchedulingConfigurer,
AutoConfig {
    private static final Logger log = LoggerFactory.getLogger(ScheduleAutoConfig.class);
    @Resource
    List<CkScheduleInfo> tasks;

    @Bean
    public CkScheduleInfo fillTask() {
        return CkScheduleInfo.builder().task(r -> {
            log.info("ckSchedule is in active...");
            return true;
        }).cron(r -> "0 0 0 * * *").taskName("\u670d\u52a1\u62a5\u6d3b Task").build();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (Objects.nonNull(this.tasks) && !this.tasks.isEmpty()) {
            this.tasks.forEach(e -> {
                log.info("ckSchedule add task {}", (Object)e.getTaskName());
                taskRegistrar.addCronTask(() -> e.getTask().apply(taskRegistrar), e.getCron().apply(taskRegistrar));
            });
        }
    }
}

