/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.validator;

import com.gomyck.util.FieldUtil;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.validator.CkValidationException;
import com.gomyck.util.validator.CkValidator;
import com.gomyck.util.validator.annotation.FieldMapping;
import com.gomyck.util.validator.annotation.ValidateByOtherField;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateByOtherFieldValidator
implements ConstraintValidator<ValidateByOtherField, Object> {
    private static final Logger log = LoggerFactory.getLogger(ValidateByOtherFieldValidator.class);
    private ValidateByOtherField validateByOtherField;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        FieldMapping[] fieldMappings = this.validateByOtherField.fieldMappings();
        Object validateEntity = CkValidator.getValidateEntity();
        for (FieldMapping fieldMapping : fieldMappings) {
            try {
                Object invoke = FieldUtil.getMethod(validateEntity.getClass(), fieldMapping.key()).invoke(validateEntity, new Object[0]);
                if (!ObjectJudge.isNull(invoke, fieldMapping.value()) && !invoke.equals(fieldMapping.value())) continue;
                switch (fieldMapping.rules()) {
                    case NOT_NULL: {
                        if (!ObjectJudge.isNull(value)) break;
                        return false;
                    }
                    case NULL: {
                        if (!ObjectJudge.notNull(value)) break;
                        return false;
                    }
                    case MUST_BE: {
                        if (fieldMapping.mustBe().equals(value)) break;
                        return false;
                    }
                }
            }
            catch (Exception e) {
                log.error("may be this field {} getter is not found", (Object)fieldMapping.key());
                throw new CkValidationException(MessageFormat.format("may be this field {0} getter is not found", fieldMapping.key()));
            }
        }
        return true;
    }

    public void initialize(ValidateByOtherField constraintAnnotation) {
        this.validateByOtherField = constraintAnnotation;
        super.initialize((Annotation)constraintAnnotation);
    }
}

