/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.velocity;

import com.gomyck.util.ObjectJudge;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateUtil {
    private static final VelocityEngine ve = new VelocityEngine();
    private static boolean initialized = false;

    private TemplateUtil() {
    }

    public static VelocityEngine init(Properties prop) {
        VelocityEngine _ve = new VelocityEngine();
        if (prop == null) {
            throw new RuntimeException("you can use simpleInject if you don`t want to input the parameter [prop]");
        }
        _ve.init(prop);
        return _ve;
    }

    public static byte[] inject(String templateFilePath, List<KVEntity> injectData, VelocityEngine ve) {
        VelocityContext context = TemplateUtil.initVelocityContext(injectData);
        Template template = ve.getTemplate(templateFilePath, StandardCharsets.UTF_8.toString());
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        return sw.toString().getBytes();
    }

    public static byte[] simpleInject(String templateFilePath, List<KVEntity> injectData) {
        return TemplateUtil.inject(templateFilePath, injectData, TemplateUtil.getVE());
    }

    public static byte[] inject(String templateString, List<KVEntity> injectData) {
        Properties prop = new Properties();
        prop.put("resource.loader", "ckStringResourceLoader");
        prop.put("ckStringResourceLoader.resource.loader.class", "com.gomyck.util.velocity.CkStringResourceLoader");
        VelocityContext context = TemplateUtil.initVelocityContext(injectData);
        VelocityEngine ve = TemplateUtil.init(prop);
        Template template = ve.getTemplate(templateString, StandardCharsets.UTF_8.toString());
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        return sw.toString().getBytes();
    }

    private static VelocityContext initVelocityContext(List<KVEntity> injectData) {
        VelocityContext context = new VelocityContext();
        injectData.forEach(e -> {
            if (ObjectJudge.notNull((Object)e.getKey())) {
                context.put(e.getKey(), e.getValue());
            } else {
                context.put(e.getKey(), (Object)"");
            }
        });
        return context;
    }

    public static KVEntity initKVEntity(String key, Object value) {
        return new KVEntity(key, value);
    }

    private static VelocityEngine getVE() {
        if (!initialized) {
            initialized = true;
            Properties prop = new Properties();
            prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init(prop);
        }
        return ve;
    }

    private static String desensitization(String param) {
        return param.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static class KVEntity {
        private String key;
        private Object value;

        KVEntity(String key, Object value) {
            this.key = key;
            this.value = value instanceof String ? TemplateUtil.desensitization((String)value) : value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KVEntity)) {
                return false;
            }
            KVEntity other = (KVEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KVEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "TemplateUtil.KVEntity(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

