/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.converter.persistent;

import com.gomyck.trans4j.converter.Converter;
import com.gomyck.trans4j.handler.ConverterHandlerComposite;
import com.gomyck.trans4j.profile.Trans4JProfiles;
import com.gomyck.trans4j.support.ConverterType;
import com.gomyck.trans4j.support.TransBus;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultCollectionConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ResultCollectionConverter.class);
    private ConverterHandlerComposite converterHandlerComposite;
    private Trans4JProfiles trans4jProfiles;

    @Override
    public Object doConvert(Object result) {
        StackTraceElement[] stackTrace;
        if (!TransBus.getConvertType().contains((Object)ConverterType.JDBC_PERSISTENT_CONVERTER)) {
            return result;
        }
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getMethodName().toUpperCase().contains(this.trans4jProfiles.getIgnoreSuffix())) continue;
            return result;
        }
        if (Objects.isNull(result)) {
            return null;
        }
        return this.converterHandlerComposite.handle(result);
    }

    public ResultCollectionConverter(ConverterHandlerComposite converterHandlerComposite, Trans4JProfiles trans4jProfiles) {
        this.converterHandlerComposite = converterHandlerComposite;
        this.trans4jProfiles = trans4jProfiles;
    }
}

