/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter;

import com.gomyck.trans4j.filter.ConverterFilter;
import com.gomyck.trans4j.filter.OuterConverterFilter;
import com.gomyck.trans4j.handler.ConverterHandler;
import com.gomyck.trans4j.support.TransBus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FilterComposite<B, A>
implements OuterConverterFilter<B, A> {
    private final List<ConverterFilter<B, A>> converterFilters = new ArrayList<ConverterFilter<B, A>>();

    public void addFilter(ConverterFilter<B, A> converterFilter) {
        if (this.converterFilters.contains(converterFilter)) {
            return;
        }
        this.converterFilters.add(converterFilter);
        this.converterFilters.sort(Comparator.comparingInt(ConverterFilter::getOrder));
    }

    @Override
    public boolean support(ConverterHandler converterHandler) {
        return true;
    }

    @Override
    public void beforeConvert(Object obj) {
        for (ConverterFilter<Object, A> converterFilter : this.converterFilters) {
            if (!converterFilter.support(TransBus.getCurrentHandler())) continue;
            converterFilter.beforeConvert(obj);
        }
    }

    @Override
    public void afterConvert(Object obj) {
        for (ConverterFilter<B, Object> converterFilter : this.converterFilters) {
            if (!converterFilter.support(TransBus.getCurrentHandler())) continue;
            converterFilter.afterConvert(obj);
        }
    }

    public void afterPropertiesSet() {
    }

    public List<ConverterFilter<B, A>> getConverterFilters() {
        return this.converterFilters;
    }
}

