/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter.dictionary;

import com.gomyck.trans4j.filter.dictionary.AbstractDicConverterFilter;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.support.ConverterUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class DicExcludeFilter
extends AbstractDicConverterFilter {
    private final Set<String> excludeColNames = new HashSet<String>();

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void clearProp() {
        this.excludeColNames.clear();
    }

    @Override
    public void afterConvert(AfterDicHandleInfo convertInfo) {
        Optional<String> any = this.excludeColNames.stream().filter(e -> e.equals(convertInfo.getCommonColName())).findAny();
        if (any.isPresent()) {
            convertInfo.setTargetValue(null);
        }
    }

    private DicExcludeFilter() {
    }

    public static DicExcludeFilter init() {
        return new DicExcludeFilter();
    }

    public DicExcludeFilter addExcludeColNames(String ... colNames) {
        for (String colName : colNames) {
            this.excludeColNames.add(ConverterUtil.getCommonColName(colName));
        }
        return this;
    }
}

