/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter.dictionary;

import com.gomyck.trans4j.filter.dictionary.AbstractDicConverterFilter;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.support.ConverterUtil;
import com.gomyck.util.DataFilter;
import com.gomyck.util.ObjectJudge;
import java.util.ArrayList;
import java.util.List;

public class DicMuchCodeFilter
extends AbstractDicConverterFilter {
    private final List<String> includeColNames = new ArrayList<String>();
    private String prefixStr = "";
    private String delimiter = ",";
    private String suffixStr = "";

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void clearProp() {
        this.includeColNames.clear();
        this.prefixStr = "";
        this.delimiter = ",";
        this.suffixStr = "";
    }

    @Override
    public void afterConvert(AfterDicHandleInfo convertInfo) {
        this.includeColNames.forEach(commonColName -> {
            if (ObjectJudge.isNull((Object)commonColName)) {
                return;
            }
            if (commonColName.equals(convertInfo.getCommonColName()) && ObjectJudge.notNull((Object)convertInfo.getOriginValue())) {
                String originValue = convertInfo.getOriginValue().toString();
                originValue = originValue.replaceFirst(this.prefixStr, "");
                originValue = DataFilter.replaceLast((String)originValue, (String)this.suffixStr, (String)"");
                String[] values = originValue.split(this.delimiter);
                StringBuffer targetValue = new StringBuffer();
                for (String s : values) {
                    targetValue.append(convertInfo.getUsedDicInfo().get(s.trim())).append(this.delimiter);
                }
                if (targetValue.lastIndexOf(this.delimiter) == targetValue.length() - 1) {
                    convertInfo.setTargetValue(targetValue.substring(0, targetValue.length() - 1));
                } else {
                    convertInfo.setTargetValue(targetValue);
                }
            }
        });
    }

    private DicMuchCodeFilter() {
    }

    public static DicMuchCodeFilter init() {
        return new DicMuchCodeFilter();
    }

    public DicMuchCodeFilter addManyValueColName(String colName) {
        this.includeColNames.add(ConverterUtil.getCommonColName(colName));
        return this;
    }

    public DicMuchCodeFilter setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public DicMuchCodeFilter setPrefixAndSuffixStr(String prefixStr, String suffixStr) {
        this.prefixStr = prefixStr == null ? "" : prefixStr;
        this.suffixStr = suffixStr == null ? "" : suffixStr;
        return this;
    }
}

