/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.handler;

import com.gomyck.trans4j.filter.FilterComposite;
import com.gomyck.trans4j.handler.ConverterHandler;
import com.gomyck.trans4j.support.TransBus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ConverterHandlerComposite
implements ConverterHandler {
    protected FilterComposite<?, ?> filterComposite;
    private final List<ConverterHandler> converterHandlers = new ArrayList<ConverterHandler>();

    public void addHandler(ConverterHandler converterHandler) {
        if (this.converterHandlers.contains(converterHandler)) {
            return;
        }
        this.converterHandlers.add(converterHandler);
        this.converterHandlers.sort(Comparator.comparingInt(ConverterHandler::getOrder));
    }

    @Override
    public boolean support(Object obj) {
        return true;
    }

    @Override
    public Object handle(Object obj) {
        if (Objects.isNull(obj)) {
            return obj;
        }
        for (ConverterHandler handler : this.converterHandlers) {
            if (!handler.support(obj)) continue;
            TransBus.setCurrentHandler(handler);
            this.filterComposite.beforeConvert(obj);
            obj = handler.beforeHandler(obj);
            if (obj == null) continue;
            handler.handle(obj);
            obj = handler.afterHandler(obj);
            if (obj == null) continue;
            this.filterComposite.afterConvert(obj);
        }
        return obj;
    }

    public ConverterHandlerComposite(FilterComposite<?, ?> filterComposite) {
        this.filterComposite = filterComposite;
    }
}

