/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.handler.dictionary;

import com.gomyck.trans4j.filter.ConverterFilter;
import com.gomyck.trans4j.filter.InnerConverterFilter;
import com.gomyck.trans4j.handler.AbstractConverterHandler;
import com.gomyck.trans4j.handler.ConverterHandlerComposite;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.handler.dictionary.BeforeDicHandleInfo;
import com.gomyck.trans4j.handler.dictionary.DicDescribeAdaptor;
import com.gomyck.trans4j.handler.dictionary.DicInfoHolder;
import com.gomyck.trans4j.handler.dictionary.serialize.AutoEncoder;
import com.gomyck.trans4j.support.ConverterUtil;
import com.gomyck.trans4j.support.TransBus;
import com.gomyck.util.DataFilter;
import com.gomyck.util.FieldUtil;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.PropertyAppender;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicConverterHandler
extends AbstractConverterHandler {
    private static final Logger log = LoggerFactory.getLogger(DicConverterHandler.class);
    public static final String V = "$V";
    private final DicDescribeAdaptor adaptor;
    private static final String SPLIT_CHARACTER = ",";
    private final Map<String, Map<String, Object>> DIC_INFO = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> DIC_INFO_OVERTURN = new ConcurrentHashMap<String, Map<String, Object>>();
    private final List<ConverterFilter<BeforeDicHandleInfo, AfterDicHandleInfo>> filters = new ArrayList<ConverterFilter<BeforeDicHandleInfo, AfterDicHandleInfo>>();
    private final AutoEncoder autoEncoder;
    private final List<Function<Object, List<Map<String, Object>>>> initDicInfoFunc = new ArrayList<Function<Object, List<Map<String, Object>>>>();

    public DicConverterHandler(DicDescribeAdaptor adaptor, AutoEncoder autoEncoder, ConverterHandlerComposite converterHandlerComposite) {
        super(converterHandlerComposite);
        this.adaptor = adaptor;
        this.autoEncoder = autoEncoder;
    }

    public String simpleConvert(boolean ifOverturn, String typeCode, String originValue) {
        Map<String, Map<String, Object>> _finalDicInfo = !ifOverturn ? this.DIC_INFO : this.DIC_INFO_OVERTURN;
        String colName = ConverterUtil.getCommonColName(typeCode);
        Map<String, Object> usedDicInfo = _finalDicInfo.get(colName);
        return DataFilter.toString((Object)usedDicInfo.get(originValue));
    }

    public void init(Function<Object, List<Map<String, Object>>> initDicInfoFunc) {
        log.info("Initializing gomyck result converter dic info ...");
        if (!this.initDicInfoFunc.contains(initDicInfoFunc)) {
            this.initDicInfoFunc.add(initDicInfoFunc);
        }
        if (initDicInfoFunc == null) {
            return;
        }
        List<Map<String, Object>> _dicInfo = initDicInfoFunc.apply(this);
        if (_dicInfo == null) {
            return;
        }
        this.initDicInfo(_dicInfo);
        this.initDicInfoOverturn(_dicInfo);
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void addInnerFilter(InnerConverterFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    private void initDicInfo(List<Map<String, Object>> _dicInfo) {
        for (Map<String, Object> _dic : _dicInfo) {
            String colNames = DataFilter.toString((Object)_dic.get(this.adaptor.COLUMN_NAME));
            Arrays.stream(colNames.split(SPLIT_CHARACTER)).forEach(colName -> {
                Map<String, Object> maps;
                colName = ConverterUtil.getCommonColName(colName);
                String code = DataFilter.toString(_dic.get(this.adaptor.CODE));
                if (ObjectJudge.isNull((Object)code)) {
                    return;
                }
                if (ObjectJudge.notNull((Object)this.adaptor.I18N)) {
                    code = code + DataFilter.getFirstNotNull((Object[])new Object[]{DataFilter.toString(_dic.get(this.adaptor.I18N)), this.adaptor.DEFAULT_I18N_FLAG, "_INVALID"});
                }
                if ((maps = this.DIC_INFO.get(colName)) != null) {
                    maps.put(code, _dic.get(this.adaptor.VALUE));
                } else {
                    maps = new ConcurrentHashMap<String, Object>();
                    maps.put(code, _dic.get(this.adaptor.VALUE));
                    this.DIC_INFO.put((String)colName, maps);
                }
            });
        }
        DicInfoHolder.DIC_INFO = this.DIC_INFO;
    }

    private void initDicInfoOverturn(List<Map<String, Object>> _dicInfo) {
        for (Map<String, Object> dic : _dicInfo) {
            String colNames = DataFilter.toString((Object)dic.get(this.adaptor.COLUMN_NAME));
            Arrays.stream(colNames.split(SPLIT_CHARACTER)).forEach(colName -> {
                colName = ConverterUtil.getCommonColName(colName);
                String value = DataFilter.toString(dic.get(this.adaptor.VALUE));
                Map<String, Object> maps = this.DIC_INFO_OVERTURN.get(colName);
                if (ObjectJudge.isNull((Object)value)) {
                    return;
                }
                if (maps != null) {
                    maps.put(value, dic.get(this.adaptor.CODE));
                } else {
                    maps = new ConcurrentHashMap<String, Object>();
                    maps.put(value, dic.get(this.adaptor.CODE));
                    this.DIC_INFO_OVERTURN.put((String)colName, maps);
                }
            });
        }
        DicInfoHolder.DIC_INFO_OVERTURN = this.DIC_INFO_OVERTURN;
    }

    @Override
    public boolean support(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            return true;
        }
        if (obj instanceof Map) {
            return true;
        }
        return !FieldUtil.isBaseType((Object)obj.getClass().getTypeName());
    }

    @Override
    public Object handle(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        Object result = super.handle(object);
        if (Objects.nonNull(result)) {
            return result;
        }
        if (object instanceof Map) {
            return this.convertDicColumnInfo4Map((Map)object);
        }
        if (!FieldUtil.isJDKClass((Object)object)) {
            return this.convertDicColumnInfo4Entity(object);
        }
        return null;
    }

    private Object convertDicColumnInfo4Map(Map<String, Object> resultSet4row) {
        boolean ifOverturn = TransBus.isOverturn();
        Map<String, Map<String, Object>> _finalDicInfo = !ifOverturn ? this.DIC_INFO : this.DIC_INFO_OVERTURN;
        HashMap addInfo = new HashMap();
        resultSet4row.keySet().forEach(resultColName -> {
            boolean ifMatchDic;
            Object recursion = this.handle(resultSet4row.get(resultColName));
            if (Objects.nonNull(recursion)) {
                resultSet4row.put((String)resultColName, recursion);
                return;
            }
            String colName = ConverterUtil.getCommonColName(resultColName);
            Map<String, Object> usedDicInfo = (Map<String, Object>)_finalDicInfo.get(colName);
            String colValue = DataFilter.toString(resultSet4row.get(resultColName));
            BeforeDicHandleInfo beforeDicHandleInfo = this.initBeforeConvertInfo(colName, colValue, usedDicInfo, _finalDicInfo);
            usedDicInfo = beforeDicHandleInfo.getUsedDicInfo();
            Object convert_col_value = null;
            boolean bl = ifMatchDic = usedDicInfo != null;
            if (ifMatchDic) {
                convert_col_value = usedDicInfo.get(colValue);
            } else {
                usedDicInfo = new HashMap<String, Object>();
            }
            AfterDicHandleInfo afterDicHandleInfo = this.initAfterConvertInfo(colName, colValue, convert_col_value, usedDicInfo, _finalDicInfo);
            convert_col_value = afterDicHandleInfo.getTargetValue();
            if (convert_col_value != null) {
                addInfo.put(resultColName.concat(V), convert_col_value);
            }
        });
        resultSet4row.putAll(addInfo);
        return resultSet4row;
    }

    private Object convertDicColumnInfo4Entity(Object resultSet4Row) {
        Object generate;
        boolean ifOverturn = TransBus.isOverturn();
        Map<String, Map<String, Object>> _finalDicInfo = !ifOverturn ? this.DIC_INFO : this.DIC_INFO_OVERTURN;
        List allFields = FieldUtil.getAllFields(resultSet4Row.getClass());
        HashMap kv = new HashMap();
        allFields.forEach(field -> {
            try {
                boolean ifMatchDic;
                Method getMethod4FieldValue = FieldUtil.getMethod(resultSet4Row.getClass(), (String)field.getName());
                Method setMethod4FieldValue = FieldUtil.setMethod(resultSet4Row.getClass(), (String)field.getName());
                Object fieldValue = getMethod4FieldValue.invoke(resultSet4Row, new Object[0]);
                Object recursion = this.handle(fieldValue);
                if (Objects.nonNull(recursion)) {
                    setMethod4FieldValue.invoke(resultSet4Row, recursion);
                    return;
                }
                String colName = ConverterUtil.getCommonColName(field.getName());
                Map<String, Object> usedDicInfo = (Map<String, Object>)_finalDicInfo.get(colName);
                String colValue = DataFilter.toString((Object)fieldValue);
                BeforeDicHandleInfo beforeDicHandleInfo = this.initBeforeConvertInfo(colName, colValue, usedDicInfo, _finalDicInfo);
                usedDicInfo = beforeDicHandleInfo.getUsedDicInfo();
                Object convert_col_value = null;
                boolean bl = ifMatchDic = usedDicInfo != null;
                if (usedDicInfo != null) {
                    convert_col_value = usedDicInfo.get(colValue);
                } else {
                    usedDicInfo = new HashMap<String, Object>();
                }
                AfterDicHandleInfo afterDicHandleInfo = this.initAfterConvertInfo(colName, colValue, convert_col_value, usedDicInfo, _finalDicInfo);
                convert_col_value = afterDicHandleInfo.getTargetValue();
                if (convert_col_value != null) {
                    kv.put(field.getName().concat(V), convert_col_value);
                }
            }
            catch (Exception e) {
                log.error("Entity trans error: {}, fieldName: {}", (Object)e, field);
            }
        });
        if (kv.isEmpty()) {
            return resultSet4Row;
        }
        try {
            generate = PropertyAppender.generate((Object)resultSet4Row, kv);
        }
        catch (Exception e) {
            e.printStackTrace();
            return resultSet4Row;
        }
        return generate;
    }

    private BeforeDicHandleInfo initBeforeConvertInfo(String commonName, Object originValue, Map<String, Object> usedDicInfo, Map<String, Map<String, Object>> overallDicInfo) {
        BeforeDicHandleInfo convertInfo = BeforeDicHandleInfo.initBeforeConvertInfo();
        convertInfo.setCommonColName(commonName);
        convertInfo.setOriginValue(originValue);
        convertInfo.setUsedDicInfo(usedDicInfo);
        convertInfo.setOverallDicInfo(overallDicInfo);
        for (ConverterFilter<BeforeDicHandleInfo, AfterDicHandleInfo> dicConvertFilter : this.filters) {
            dicConvertFilter.beforeConvert(convertInfo);
        }
        List<ConverterFilter> tempFilter = TransBus.getTempFilter();
        if (tempFilter != null) {
            for (ConverterFilter dicConvertFilter : tempFilter) {
                dicConvertFilter.beforeConvert(convertInfo);
            }
        }
        return convertInfo;
    }

    private AfterDicHandleInfo initAfterConvertInfo(String commonName, Object originValue, Object targetValue, Map<String, Object> usedDicInfo, Map<String, Map<String, Object>> overallDicInfo) {
        AfterDicHandleInfo convertInfo = AfterDicHandleInfo.initAfterConvertInfo();
        convertInfo.setCommonColName(commonName);
        convertInfo.setOriginValue(originValue);
        convertInfo.setTargetValue(targetValue);
        convertInfo.setUsedDicInfo(usedDicInfo);
        convertInfo.setAdaptor(this.adaptor);
        convertInfo.setOverallDicInfo(overallDicInfo);
        for (ConverterFilter<BeforeDicHandleInfo, AfterDicHandleInfo> dicConvertFilter : this.filters) {
            dicConvertFilter.afterConvert(convertInfo);
        }
        List<ConverterFilter> tempFilter = TransBus.getTempFilter();
        if (tempFilter != null) {
            for (ConverterFilter dicConvertFilter : tempFilter) {
                dicConvertFilter.afterConvert(convertInfo);
            }
        }
        return convertInfo;
    }

    @Override
    public Object beforeHandler(Object input) {
        return this.autoEncoder.encode(input);
    }

    public List<Function<Object, List<Map<String, Object>>>> getInitDicInfoFunc() {
        return this.initDicInfoFunc;
    }
}

