/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.Objects;
import proguard.analysis.cpa.bam.BamLocationDependent;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class BamLocationDependentJvmMemoryLocation<AbstractStateT extends AbstractState & ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature>>
implements ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature>,
BamLocationDependent<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> {
    private final JvmMemoryLocation memoryLocation;
    private JvmCfaNode programLocation;
    private ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet;

    public BamLocationDependentJvmMemoryLocation(JvmMemoryLocation memoryLocation) {
        this(memoryLocation, null, null);
    }

    public BamLocationDependentJvmMemoryLocation(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet) {
        this.memoryLocation = memoryLocation;
        this.programLocation = programLocation;
        this.sourceReachedSet = sourceReachedSet;
    }

    public JvmMemoryLocation getMemoryLocation() {
        return this.memoryLocation;
    }

    public BamLocationDependentJvmMemoryLocation<AbstractStateT> copy() {
        return new BamLocationDependentJvmMemoryLocation<AbstractStateT>(this.memoryLocation, this.programLocation, this.sourceReachedSet);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.programLocation;
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.programLocation = programLocation;
    }

    @Override
    public ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> getSourceReachedSet() {
        return this.sourceReachedSet;
    }

    @Override
    public void setSourceReachedSet(ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet) {
        this.sourceReachedSet = sourceReachedSet;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BamLocationDependentJvmMemoryLocation)) {
            return false;
        }
        BamLocationDependentJvmMemoryLocation other = (BamLocationDependentJvmMemoryLocation)obj;
        return this.sourceReachedSet == other.sourceReachedSet && this.programLocation == other.programLocation && Objects.equals(this.memoryLocation, other.memoryLocation);
    }

    public int hashCode() {
        return Objects.hash(this.memoryLocation, this.programLocation, this.sourceReachedSet);
    }

    public String toString() {
        return this.memoryLocation.toString() + (this.programLocation == null ? "" : "@" + this.programLocation.getSignature().getFqn() + ":" + this.programLocation.getOffset());
    }
}

