/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.BootstrapMethodHandleTraveler;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class DynamicConstant
extends Constant {
    public int u2bootstrapMethodAttributeIndex;
    public int u2nameAndTypeIndex;
    public Clazz[] referencedClasses;

    public DynamicConstant() {
    }

    public DynamicConstant(int u2bootstrapMethodAttributeIndex, int u2nameAndTypeIndex, Clazz[] referencedClasses) {
        this.u2bootstrapMethodAttributeIndex = u2bootstrapMethodAttributeIndex;
        this.u2nameAndTypeIndex = u2nameAndTypeIndex;
        this.referencedClasses = referencedClasses;
    }

    public int getBootstrapMethodAttributeIndex() {
        return this.u2bootstrapMethodAttributeIndex;
    }

    public int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    public String getName(Clazz clazz) {
        return clazz.getName(this.u2nameAndTypeIndex);
    }

    public String getType(Clazz clazz) {
        return clazz.getType(this.u2nameAndTypeIndex);
    }

    public void referencedClassesAccept(ClassVisitor classVisitor) {
        if (this.referencedClasses != null) {
            for (int index = 0; index < this.referencedClasses.length; ++index) {
                if (this.referencedClasses[index] == null) continue;
                this.referencedClasses[index].accept(classVisitor);
            }
        }
    }

    public void bootstrapMethodHandleAccept(Clazz clazz, ConstantVisitor constantVisitor) {
        new BootstrapMethodHandleTraveler(constantVisitor).visitDynamicConstant(clazz, this);
    }

    @Override
    public int getTag() {
        return 17;
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitDynamicConstant(clazz, this);
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        DynamicConstant other = (DynamicConstant)object;
        return this.u2bootstrapMethodAttributeIndex == other.u2bootstrapMethodAttributeIndex && this.u2nameAndTypeIndex == other.u2nameAndTypeIndex;
    }

    public int hashCode() {
        return 0x11 ^ this.u2bootstrapMethodAttributeIndex << 5 ^ this.u2nameAndTypeIndex << 16;
    }

    public String toString() {
        return "Dynamic(" + this.u2bootstrapMethodAttributeIndex + "," + this.u2nameAndTypeIndex + ")";
    }
}

