/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceSorter
implements ClassVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        if (interfacesCount > 1) {
            Arrays.sort(interfaces, 0, interfacesCount);
            programClass.attributesAccept(this);
            boolean[] delete = null;
            for (int index = 1; index < interfacesCount; ++index) {
                if (interfaces[index] != interfaces[index - 1]) continue;
                if (delete == null) {
                    delete = new boolean[interfacesCount];
                }
                delete[index] = true;
            }
            if (delete != null) {
                new InterfaceDeleter(delete, false).visitProgramClass(programClass);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        int counter;
        int classCount;
        String type;
        Clazz[] referencedClasses = signatureAttribute.referencedClasses;
        Clazz[] newReferencedClasses = referencedClasses == null ? null : new Clazz[referencedClasses.length];
        StringBuffer newSignatureBuffer = new StringBuffer();
        int referencedClassIndex = 0;
        int newReferencedClassIndex = 0;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signatureAttribute.getSignature(clazz));
        if (internalTypeEnumeration.hasFormalTypeParameters()) {
            type = internalTypeEnumeration.formalTypeParameters();
            newSignatureBuffer.append(type);
            if (newReferencedClasses != null) {
                classCount = new DescriptorClassEnumeration(type).classCount();
                for (counter = 0; counter < classCount; ++counter) {
                    newReferencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                }
            }
        }
        if (internalTypeEnumeration.hasMoreTypes()) {
            type = internalTypeEnumeration.nextType();
            newSignatureBuffer.append(type);
            if (newReferencedClasses != null) {
                classCount = new DescriptorClassEnumeration(type).classCount();
                for (counter = 0; counter < classCount; ++counter) {
                    newReferencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                }
            }
        }
        int firstReferencedInterfaceIndex = referencedClassIndex;
        for (int interfaceIndex = 0; interfaceIndex < clazz.getInterfaceCount(); ++interfaceIndex) {
            String interfaceName = clazz.getInterfaceName(interfaceIndex);
            referencedClassIndex = firstReferencedInterfaceIndex;
            InternalTypeEnumeration internalInterfaceTypeEnumeration = new InternalTypeEnumeration(signatureAttribute.getSignature(clazz));
            internalInterfaceTypeEnumeration.nextType();
            while (internalInterfaceTypeEnumeration.hasMoreTypes()) {
                String type2 = internalInterfaceTypeEnumeration.nextType();
                DescriptorClassEnumeration classEnumeration = new DescriptorClassEnumeration(type2);
                int classCount2 = classEnumeration.classCount();
                classEnumeration.nextFluff();
                if (interfaceName.equals(classEnumeration.nextClassName())) {
                    newSignatureBuffer.append(type2);
                    if (newReferencedClasses == null) continue;
                    for (int counter2 = 0; counter2 < classCount2; ++counter2) {
                        newReferencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                    }
                    continue;
                }
                referencedClassIndex += classCount2;
            }
        }
        String newSignature = newSignatureBuffer.toString();
        if (!newSignature.equals(signatureAttribute.getSignature(clazz))) {
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            signatureAttribute.referencedClasses = newReferencedClasses;
        }
    }
}

