/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor.filter;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;

public class KotlinPropertyFilter
implements KotlinPropertyVisitor {
    private final KotlinPropertyVisitor acceptedPropertyVisitor;
    private final KotlinPropertyVisitor rejectedPropertyVisitor;
    private final Predicate<KotlinPropertyMetadata> predicate;

    public KotlinPropertyFilter(Predicate<KotlinPropertyMetadata> predicate, KotlinPropertyVisitor acceptedPropertyVisitor, KotlinPropertyVisitor rejectedPropertyVisitor) {
        this.acceptedPropertyVisitor = acceptedPropertyVisitor;
        this.rejectedPropertyVisitor = rejectedPropertyVisitor;
        this.predicate = predicate;
    }

    public KotlinPropertyFilter(Predicate<KotlinPropertyMetadata> predicate, KotlinPropertyVisitor acceptedPropertyVisitor) {
        this(predicate, acceptedPropertyVisitor, null);
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        KotlinPropertyVisitor visitor;
        KotlinPropertyVisitor kotlinPropertyVisitor = visitor = this.predicate.test(kotlinPropertyMetadata) ? this.acceptedPropertyVisitor : this.rejectedPropertyVisitor;
        if (visitor != null) {
            visitor.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
        }
    }
}

