/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import org.jetbrains.annotations.NotNull;
import proguard.analysis.datastructure.CodeLocation;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.evaluation.value.ArrayReferenceValueFactory;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObject;

public class ParticularValueFactory
extends BasicValueFactory
implements ValueFactory {
    static final IntegerValue INTEGER_VALUE_M1 = new ParticularIntegerValue(-1);
    static final IntegerValue INTEGER_VALUE_0 = new ParticularIntegerValue(0);
    static final IntegerValue INTEGER_VALUE_1 = new ParticularIntegerValue(1);
    static final IntegerValue INTEGER_VALUE_2 = new ParticularIntegerValue(2);
    static final IntegerValue INTEGER_VALUE_3 = new ParticularIntegerValue(3);
    static final IntegerValue INTEGER_VALUE_4 = new ParticularIntegerValue(4);
    static final IntegerValue INTEGER_VALUE_5 = new ParticularIntegerValue(5);
    static final LongValue LONG_VALUE_0 = new ParticularLongValue(0L);
    static final LongValue LONG_VALUE_1 = new ParticularLongValue(1L);
    static final FloatValue FLOAT_VALUE_0 = new ParticularFloatValue(0.0f);
    static final FloatValue FLOAT_VALUE_1 = new ParticularFloatValue(1.0f);
    static final FloatValue FLOAT_VALUE_2 = new ParticularFloatValue(2.0f);
    static final DoubleValue DOUBLE_VALUE_0 = new ParticularDoubleValue(0.0);
    static final DoubleValue DOUBLE_VALUE_1 = new ParticularDoubleValue(1.0);
    private static final int POS_ZERO_FLOAT_BITS = Float.floatToIntBits(0.0f);
    private static final long POS_ZERO_DOUBLE_BITS = Double.doubleToLongBits(0.0);
    private final ValueFactory arrayReferenceValueFactory;
    private final ValueFactory referenceValueFactory;

    public ParticularValueFactory() {
        this(new ArrayReferenceValueFactory(), new TypedReferenceValueFactory());
    }

    public ParticularValueFactory(ValueFactory referenceValueFactory) {
        this(referenceValueFactory, referenceValueFactory);
    }

    public ParticularValueFactory(ValueFactory arrayReferenceValueFactory, ValueFactory referenceValueFactory) {
        this.arrayReferenceValueFactory = arrayReferenceValueFactory;
        this.referenceValueFactory = referenceValueFactory;
    }

    @Override
    public IntegerValue createIntegerValue(int value) {
        switch (value) {
            case -1: {
                return INTEGER_VALUE_M1;
            }
            case 0: {
                return INTEGER_VALUE_0;
            }
            case 1: {
                return INTEGER_VALUE_1;
            }
            case 2: {
                return INTEGER_VALUE_2;
            }
            case 3: {
                return INTEGER_VALUE_3;
            }
            case 4: {
                return INTEGER_VALUE_4;
            }
            case 5: {
                return INTEGER_VALUE_5;
            }
        }
        return new ParticularIntegerValue(value);
    }

    @Override
    public LongValue createLongValue(long value) {
        return value == 0L ? LONG_VALUE_0 : (value == 1L ? LONG_VALUE_1 : new ParticularLongValue(value));
    }

    @Override
    public FloatValue createFloatValue(float value) {
        return value == 0.0f && Float.floatToIntBits(value) == POS_ZERO_FLOAT_BITS ? FLOAT_VALUE_0 : (value == 1.0f ? FLOAT_VALUE_1 : (value == 2.0f ? FLOAT_VALUE_2 : new ParticularFloatValue(value)));
    }

    @Override
    public DoubleValue createDoubleValue(double value) {
        return value == 0.0 && Double.doubleToLongBits(value) == POS_ZERO_DOUBLE_BITS ? DOUBLE_VALUE_0 : (value == 1.0 ? DOUBLE_VALUE_1 : new ParticularDoubleValue(value));
    }

    @Override
    public ReferenceValue createReferenceValue() {
        return this.referenceValueFactory.createReferenceValue();
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return this.referenceValueFactory.createReferenceValueNull();
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return this.referenceValueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object value) {
        return this.referenceValueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, value);
    }

    @Override
    public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, @NotNull AnalyzedObject value) {
        ParticularValueFactory.checkReferenceValue(value);
        return this.referenceValueFactory.createReferenceValue(referencedClass, mayBeExtension, mayBeNull, value);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset) {
        return this.referenceValueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, creationClass, creationMethod, creationOffset);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.referenceValueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, creationClass, creationMethod, creationOffset, value);
    }

    @Override
    public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, CodeLocation creationLocation, @NotNull AnalyzedObject value) {
        ParticularValueFactory.checkReferenceValue(value);
        ParticularValueFactory.checkCreationLocation(creationLocation);
        return this.referenceValueFactory.createReferenceValue(referencedClass, mayBeExtension, mayBeNull, creationLocation, value);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, Object value) {
        return this.referenceValueFactory.createReferenceValueForId(type, referencedClass, mayBeExtension, mayBeNull, id, value);
    }

    @Override
    public ReferenceValue createReferenceValueForId(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, @NotNull AnalyzedObject value) {
        ParticularValueFactory.checkReferenceValue(value);
        return this.referenceValueFactory.createReferenceValueForId(referencedClass, mayBeExtension, mayBeNull, id, value);
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id) {
        return this.referenceValueFactory.createReferenceValueForId(type, referencedClass, mayBeExtension, mayBeNull, id);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return this.arrayReferenceValueFactory.createArrayReferenceValue(type, referencedClass, arrayLength);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
        return this.arrayReferenceValueFactory.createArrayReferenceValue(type, referencedClass, arrayLength, elementValues);
    }
}

