/*
 * Decompiled with CFR 0.152.
 */
package proguard.exception;

import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.exception.ProguardCoreException;
import proguard.util.CircularIntBuffer;

public class InstructionExceptionFormatter {
    private final Logger logger;
    private final CircularIntBuffer offsetBuffer;
    private final byte[] code;
    private final Clazz clazz;
    private final Method method;

    public InstructionExceptionFormatter(Logger logger, CircularIntBuffer offsetBuffer, byte[] code, Clazz clazz, Method method) {
        this.logger = logger;
        this.offsetBuffer = offsetBuffer;
        this.code = code;
        this.clazz = clazz;
        this.method = method;
    }

    public void registerInstructionOffset(int offset) {
        this.offsetBuffer.push(offset);
    }

    public void printException(ProguardCoreException exception) {
        this.printException(exception, null, null);
    }

    public void printException(ProguardCoreException exception, TracedVariables variables, TracedStack stack) {
        String ANSI_RESET = "\u001b[0m";
        String ANSI_BOLD = "\u001b[1m";
        String ANSI_RED = "\u001b[31m";
        String ANSI_CYAN = "\u001b[34m";
        Instruction erroreousInstruction = InstructionFactory.create(this.code, this.offsetBuffer.peek());
        String errorInstructionString = erroreousInstruction.toString();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("\u001b[31m").append("\u001b[1m").append("error[").append(exception.getComponentErrorId()).append("]: ").append("\u001b[0m").append(exception.getClass().getName()).append("\n");
        if (this.clazz != null && this.method != null) {
            messageBuilder.append("\u001b[34m").append("  --> ").append("\u001b[0m").append(this.clazz.getName()).append(" : ").append(this.method.getName(this.clazz)).append(this.method.getDescriptor(this.clazz)).append(" at ").append(errorInstructionString).append("\n");
        }
        for (int i = this.offsetBuffer.size() - 1; i > 0; --i) {
            Instruction prevInstruction = InstructionFactory.create(this.code, this.offsetBuffer.peek(i));
            int offset = this.offsetBuffer.peek(i);
            messageBuilder.append("\u001b[34m").append(offset).append(" |     ").append("\u001b[0m").append(prevInstruction).append("\n");
        }
        int offset = this.offsetBuffer.peek();
        messageBuilder.append("\u001b[34m").append(offset).append(" |").append("\u001b[0m").append("     ").append(errorInstructionString).append("\n");
        String indicators = new String(new char[errorInstructionString.length()]).replace('\u0000', '^');
        messageBuilder.append("  ").append("\u001b[34m").append("|").append("\u001b[0m").append("     ").append("\u001b[31m").append(indicators).append(" ").append(exception.getMessage()).append("\u001b[0m").append("\n");
        int nextOffset = this.offsetBuffer.peek() + erroreousInstruction.length(this.offsetBuffer.peek());
        if (nextOffset < this.code.length) {
            messageBuilder.append("\u001b[34m").append(nextOffset).append(" |     ").append("\u001b[0m").append(InstructionFactory.create(this.code, nextOffset)).append("\n");
        }
        if (variables != null) {
            messageBuilder.append("Variables: ").append(variables).append("\n");
        }
        if (stack != null) {
            messageBuilder.append("Stack: ").append(stack).append("\n");
        }
        this.logger.warn(messageBuilder.toString(), (Throwable)exception);
    }
}

