/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.AndStringFunction;
import proguard.util.ListUtil;
import proguard.util.NameParser;
import proguard.util.NotStringFunction;
import proguard.util.OrStringFunction;
import proguard.util.SingleFunctionParser;
import proguard.util.StringFunction;
import proguard.util.StringFunctionParser;
import proguard.util.WildcardManager;

public class ListFunctionParser
implements StringFunctionParser {
    private final StringFunctionParser stringFunctionParser;

    public ListFunctionParser(StringFunctionParser stringFunctionParser) {
        this.stringFunctionParser = stringFunctionParser;
    }

    @Override
    public StringFunction parse(String regularExpression) {
        return this.parse(ListUtil.commaSeparatedList(regularExpression));
    }

    public StringFunction parse(List regularExpressions) {
        StringFunction listFunction = null;
        for (int index = regularExpressions.size() - 1; index >= 0; --index) {
            String regularExpression = (String)regularExpressions.get(index);
            StringFunction entryFunction = this.parseEntry(regularExpression);
            listFunction = listFunction == null ? entryFunction : (this.isNegated(regularExpression) ? new AndStringFunction(entryFunction, listFunction) : new OrStringFunction(entryFunction, listFunction));
        }
        return listFunction == null ? StringFunction.IDENTITY_FUNCTION : listFunction;
    }

    private StringFunction parseEntry(String regularExpression) {
        return this.isNegated(regularExpression) ? new NotStringFunction(this.stringFunctionParser.parse(regularExpression.substring(1))) : this.stringFunctionParser.parse(regularExpression);
    }

    private boolean isNegated(String regularExpression) {
        return regularExpression.length() > 0 && regularExpression.charAt(0) == '!';
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            WildcardManager wildcardManager = new WildcardManager();
            NameParser stringParser = new NameParser(wildcardManager);
            ListFunctionParser stringFunctionParser = new ListFunctionParser(new SingleFunctionParser(stringParser, wildcardManager));
            StringFunction function = stringFunctionParser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> tranformed = " + function.transform(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

