/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.hortonworks.registries.schemaregistry.errors.ConfigTypeConversionException;
import java.io.Serializable;
import java.util.Collections;

public final class ConfigEntry<T>
implements Serializable {
    private static final long serialVersionUID = -3408548579276359761L;
    private final String name;
    private final Class<? extends T> type;
    private final String description;
    private final boolean mandatory;
    private final T defaultValue;
    private final Converter<? extends T> converter;
    private final Validator<? extends T> validator;

    private ConfigEntry(String name, Class<? extends T> type, String description, boolean mandatory, T defaultValue, Converter<? extends T> converter, Validator<? extends T> validator) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.mandatory = mandatory;
        this.defaultValue = defaultValue;
        this.converter = converter;
        this.validator = validator;
    }

    public static <T> ConfigEntry<T> mandatory(String name, Class<? extends T> type, String description, T defaultValue, Converter<? extends T> converter, Validator<? extends T> validator) {
        return new ConfigEntry<T>(name, type, description, true, defaultValue, converter, validator);
    }

    public static <T> ConfigEntry<T> optional(String name, Class<? extends T> type, String description, T defaultValue, Converter<? extends T> converter, Validator<? extends T> validator) {
        return new ConfigEntry<T>(name, type, description, false, defaultValue, converter, validator);
    }

    public String name() {
        return this.name;
    }

    public Class<? extends T> type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public Validator<? extends T> validator() {
        return this.validator;
    }

    public Converter<? extends T> converter() {
        return this.converter;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)o;
        if (this.mandatory != that.mandatory) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        return this.validator != null ? this.validator.equals(that.validator) : that.validator == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.mandatory ? 1 : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigEntry{name='" + this.name + '\'' + ", type=" + this.type + ", description='" + this.description + '\'' + ", mandatory=" + this.mandatory + ", defaultValue=" + this.defaultValue + ", validator=" + this.validator + '}';
    }

    public static class PositiveNumberValidator
    implements Validator<Number> {
        private static final PositiveNumberValidator instance = new PositiveNumberValidator();

        @Override
        public void validate(Number number) {
            if (number.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("Given number " + number + " must be greater than zero.");
            }
        }

        public static PositiveNumberValidator get() {
            return instance;
        }
    }

    public static class NonEmptyStringValidator
    implements Validator<String> {
        private static Validator<String> instance = new NonEmptyStringValidator();

        @Override
        public void validate(String str) {
            if (str == null || str.isEmpty()) {
                throw new IllegalArgumentException("Given string " + str + " must be non empty");
            }
        }

        public static Validator<String> get() {
            return instance;
        }
    }

    public static interface Validator<V> {
        public void validate(V var1);

        default public Validator<V> with(Validator<V> other) {
            return this.with(Collections.singletonList(other));
        }

        default public Validator<V> with(Iterable<Validator<V>> others) {
            return v -> {
                this.validate(v);
                for (Validator other : others) {
                    other.validate(v);
                }
            };
        }
    }

    public static class StringConverter
    implements Converter<String> {
        private static final Converter<String> instance = new StringConverter();

        @Override
        public String convert(Object obj) {
            if (obj instanceof String) {
                return (String)obj;
            }
            return obj.toString();
        }

        public static Converter<String> get() {
            return instance;
        }
    }

    public static class IntegerConverter
    implements Converter<Integer> {
        private static final Converter<Integer> instance = new IntegerConverter();

        @Override
        public Integer convert(Object obj) {
            if (obj instanceof String) {
                try {
                    return Integer.valueOf((String)obj);
                }
                catch (NumberFormatException e) {
                    throw new ConfigTypeConversionException(String.format("Value: %s can't be parsed as an Integer", obj), e);
                }
            }
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            throw new ConfigTypeConversionException(String.format("Value: %s (type: %s) is expected to be convertible to an Integer", obj, obj.getClass().getCanonicalName()));
        }

        public static Converter<Integer> get() {
            return instance;
        }
    }

    public static interface Converter<T> {
        public T convert(Object var1);
    }
}

