/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.avro;

import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.SchemaCompatibility;
import com.hortonworks.registries.schemaregistry.SchemaValidator;
import com.hortonworks.registries.schemaregistry.avro.BackwardCompatibilityValidator;
import com.hortonworks.registries.schemaregistry.avro.BothCompatibilityValidator;
import com.hortonworks.registries.schemaregistry.avro.ForwardCompatibilityValidator;
import com.hortonworks.registries.schemaregistry.avro.NoneCompatibilityValidator;
import com.hortonworks.registries.schemaregistry.avro.SchemaCompatibilityValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroSchemaValidator
implements SchemaValidator<Schema> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaValidator.class);
    private static final Map<SchemaCompatibility, SchemaCompatibilityValidator> COMPATIBILITY_VALIDATORS;
    public static final String READER_WRITER_COMPATIBLE_MESSAGE = "Reader schema can always successfully decode data written using the writer schema.";

    static SchemaCompatibilityValidator<Schema> of(SchemaCompatibility compatibility) {
        return COMPATIBILITY_VALIDATORS.get((Object)compatibility);
    }

    private AvroSchemaValidator() {
    }

    @Override
    public CompatibilityResult validate(Schema readerSchema, Schema writerSchema) {
        SchemaPairCompatibility schemaPairCompatibility = AvroSchemaValidator.checkReaderWriterCompatibility(readerSchema, writerSchema);
        SchemaCompatibilityResult result = schemaPairCompatibility.getResult();
        return result.getCompatibility() == SchemaCompatibilityType.COMPATIBLE ? CompatibilityResult.createCompatibleResult(writerSchema.toString()) : CompatibilityResult.createIncompatibleResult(result.getMessage(), result.getLocation(), writerSchema.toString());
    }

    public static SchemaPairCompatibility checkReaderWriterCompatibility(Schema reader, Schema writer) {
        String message;
        SchemaCompatibilityResult compatibility = new ReaderWriterCompatiblityChecker().getCompatibility(reader, writer);
        switch (compatibility.getCompatibility()) {
            case INCOMPATIBLE: {
                message = String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", writer.toString(true), reader.toString(true));
                break;
            }
            case COMPATIBLE: {
                message = READER_WRITER_COMPATIBLE_MESSAGE;
                break;
            }
            default: {
                throw new AvroRuntimeException("Unknown compatibility: " + compatibility);
            }
        }
        return new SchemaPairCompatibility(compatibility, reader, writer, message);
    }

    public static boolean schemaNameEquals(Schema reader, Schema writer) {
        String writerFullName = writer.getFullName();
        if (AvroSchemaValidator.objectsEqual(reader.getFullName(), writerFullName)) {
            return true;
        }
        return reader.getAliases().contains(writerFullName);
    }

    public static Schema.Field lookupWriterField(Schema writerSchema, Schema.Field readerField) {
        assert (writerSchema.getType() == Schema.Type.RECORD);
        ArrayList<Schema.Field> writerFields = new ArrayList<Schema.Field>();
        Schema.Field direct = writerSchema.getField(readerField.name());
        if (direct != null) {
            writerFields.add(direct);
        }
        for (String readerFieldAliasName : readerField.aliases()) {
            Schema.Field writerField = writerSchema.getField(readerFieldAliasName);
            if (writerField == null) continue;
            writerFields.add(writerField);
        }
        switch (writerFields.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Schema.Field)writerFields.get(0);
            }
        }
        throw new AvroRuntimeException(String.format("Reader record field %s matches multiple fields in writer record schema %s", readerField, writerSchema));
    }

    private static boolean objectsEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    static {
        AvroSchemaValidator avroSchemaValidator = new AvroSchemaValidator();
        HashMap<SchemaCompatibility, SchemaCompatibilityValidator<Object>> validators = new HashMap<SchemaCompatibility, SchemaCompatibilityValidator<Object>>();
        validators.put(SchemaCompatibility.BACKWARD, new BackwardCompatibilityValidator<Schema>(avroSchemaValidator));
        validators.put(SchemaCompatibility.FORWARD, new ForwardCompatibilityValidator<Schema>(avroSchemaValidator));
        validators.put(SchemaCompatibility.BOTH, new BothCompatibilityValidator<Schema>(avroSchemaValidator));
        validators.put(SchemaCompatibility.NONE, new NoneCompatibilityValidator());
        COMPATIBILITY_VALIDATORS = Collections.unmodifiableMap(validators);
    }

    public static final class SchemaPairCompatibility {
        private final SchemaCompatibilityResult result;
        private final Schema reader;
        private final Schema writer;
        private final String description;

        public SchemaPairCompatibility(SchemaCompatibilityResult result, Schema reader, Schema writer, String description) {
            this.result = result;
            this.reader = reader;
            this.writer = writer;
            this.description = description;
        }

        public SchemaCompatibilityType getType() {
            return this.result.getCompatibility();
        }

        public SchemaCompatibilityResult getResult() {
            return this.result;
        }

        public Schema getReader() {
            return this.reader;
        }

        public Schema getWriter() {
            return this.writer;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("SchemaPairCompatibility{result:%s, readerSchema:%s, writerSchema:%s, description:%s}", this.result, this.reader, this.writer, this.description);
        }

        public boolean equals(Object other) {
            if (null != other && other instanceof SchemaPairCompatibility) {
                SchemaPairCompatibility result = (SchemaPairCompatibility)other;
                return AvroSchemaValidator.objectsEqual(result.result, this.result) && AvroSchemaValidator.objectsEqual(result.reader, this.reader) && AvroSchemaValidator.objectsEqual(result.writer, this.writer) && AvroSchemaValidator.objectsEqual(result.description, this.description);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.result, this.reader, this.writer, this.description});
        }
    }

    public static final class SchemaCompatibilityResult {
        private final SchemaCompatibilityType compatibility;
        private final SchemaIncompatibilityType schemaIncompatibilityType;
        private final Schema readerSubset;
        private final Schema writerSubset;
        private final String message;
        private final List<String> location;
        private static final SchemaCompatibilityResult COMPATIBLE = new SchemaCompatibilityResult(SchemaCompatibilityType.COMPATIBLE, null, null, null, null, null);
        private static final SchemaCompatibilityResult RECURSION_IN_PROGRESS = new SchemaCompatibilityResult(SchemaCompatibilityType.RECURSION_IN_PROGRESS, null, null, null, null, null);

        private SchemaCompatibilityResult(SchemaCompatibilityType type, SchemaIncompatibilityType errorDetails, Schema readerDetails, Schema writerDetails, String message, List<String> location) {
            this.compatibility = type;
            this.schemaIncompatibilityType = errorDetails;
            this.readerSubset = readerDetails;
            this.writerSubset = writerDetails;
            this.message = message;
            this.location = location;
        }

        public static SchemaCompatibilityResult compatible() {
            return COMPATIBLE;
        }

        private static SchemaCompatibilityResult recursionInProgress() {
            return RECURSION_IN_PROGRESS;
        }

        public static SchemaCompatibilityResult incompatible(SchemaIncompatibilityType error, Schema reader, Schema writer, String message, List<String> location) {
            return new SchemaCompatibilityResult(SchemaCompatibilityType.INCOMPATIBLE, error, reader, writer, message, location);
        }

        public SchemaCompatibilityType getCompatibility() {
            return this.compatibility;
        }

        public SchemaIncompatibilityType getIncompatibility() {
            return this.schemaIncompatibilityType;
        }

        public Schema getReaderSubset() {
            return this.readerSubset;
        }

        public Schema getWriterSubset() {
            return this.writerSubset;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.readerSubset == null ? 0 : this.readerSubset.hashCode());
            result = 31 * result + (this.compatibility == null ? 0 : this.compatibility.hashCode());
            result = 31 * result + (this.schemaIncompatibilityType == null ? 0 : this.schemaIncompatibilityType.hashCode());
            result = 31 * result + (this.writerSubset == null ? 0 : this.writerSubset.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaCompatibilityResult other = (SchemaCompatibilityResult)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.readerSubset == null ? other.readerSubset != null : !this.readerSubset.equals((Object)other.readerSubset)) {
                return false;
            }
            if (this.compatibility != other.compatibility) {
                return false;
            }
            if (this.schemaIncompatibilityType != other.schemaIncompatibilityType) {
                return false;
            }
            if (this.writerSubset == null ? other.writerSubset != null : !this.writerSubset.equals((Object)other.writerSubset)) {
                return false;
            }
            return !(this.location == null ? other.location != null : !this.location.equals(other.location));
        }

        public String toString() {
            return String.format("SchemaCompatibilityResult{compatibility:%s, type:%s, readerSubset:%s, writerSubset:%s, message:%s, location:%s}", new Object[]{this.compatibility, this.schemaIncompatibilityType, this.readerSubset, this.writerSubset, this.message, this.getLocation()});
        }

        public String getLocation() {
            if (this.compatibility != SchemaCompatibilityType.INCOMPATIBLE) {
                return null;
            }
            StringBuilder s = new StringBuilder("/");
            boolean first = true;
            for (String coordinate : this.location.subList(1, this.location.size())) {
                if (first) {
                    first = false;
                } else {
                    s.append('/');
                }
                s.append(coordinate.replace("~", "~0").replace("/", "~1"));
            }
            return s.toString();
        }
    }

    public static enum SchemaIncompatibilityType {
        NAME_MISMATCH,
        FIXED_SIZE_MISMATCH,
        MISSING_ENUM_SYMBOLS,
        READER_FIELD_MISSING_DEFAULT_VALUE,
        TYPE_MISMATCH,
        MISSING_UNION_BRANCH;

    }

    public static enum SchemaCompatibilityType {
        COMPATIBLE,
        INCOMPATIBLE,
        RECURSION_IN_PROGRESS;

    }

    private static final class ReaderWriterCompatiblityChecker {
        private static final String ROOT_REFERENCE_TOKEN = "";
        private final Map<ReaderWriter, SchemaCompatibilityResult> mMemoizeMap = new HashMap<ReaderWriter, SchemaCompatibilityResult>();

        private ReaderWriterCompatiblityChecker() {
        }

        public SchemaCompatibilityResult getCompatibility(Schema reader, Schema writer) {
            Stack<String> location = new Stack<String>();
            return this.getCompatibility(ROOT_REFERENCE_TOKEN, reader, writer, location);
        }

        private SchemaCompatibilityResult getCompatibility(String referenceToken, Schema reader, Schema writer, Stack<String> location) {
            location.push(referenceToken);
            LOG.debug("Checking compatibility of reader {} with writer {}", (Object)reader, (Object)writer);
            ReaderWriter pair = new ReaderWriter(reader, writer);
            SchemaCompatibilityResult existing = this.mMemoizeMap.get(pair);
            if (existing != null) {
                if (existing.getCompatibility() == SchemaCompatibilityType.RECURSION_IN_PROGRESS) {
                    location.pop();
                    return SchemaCompatibilityResult.compatible();
                }
                return existing;
            }
            this.mMemoizeMap.put(pair, SchemaCompatibilityResult.recursionInProgress());
            SchemaCompatibilityResult calculated = this.calculateCompatibility(reader, writer, location);
            if (calculated == SchemaCompatibilityResult.COMPATIBLE) {
                location.pop();
            }
            this.mMemoizeMap.put(pair, calculated);
            return calculated;
        }

        private SchemaCompatibilityResult calculateCompatibility(Schema reader, Schema writer, Stack<String> location) {
            assert (reader != null);
            assert (writer != null);
            if (reader.getType() == writer.getType()) {
                switch (reader.getType()) {
                    case NULL: 
                    case BOOLEAN: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BYTES: 
                    case STRING: {
                        return SchemaCompatibilityResult.compatible();
                    }
                    case ARRAY: {
                        return this.getCompatibility("items", reader.getElementType(), writer.getElementType(), location);
                    }
                    case MAP: {
                        return this.getCompatibility("values", reader.getValueType(), writer.getValueType(), location);
                    }
                    case FIXED: {
                        SchemaCompatibilityResult nameCheck = this.checkSchemaNames(reader, writer, location);
                        if (nameCheck.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                            return nameCheck;
                        }
                        return this.checkFixedSize(reader, writer, location);
                    }
                    case ENUM: {
                        SchemaCompatibilityResult nameCheck = this.checkSchemaNames(reader, writer, location);
                        if (nameCheck.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                            return nameCheck;
                        }
                        return this.checkReaderEnumContainsAllWriterEnumSymbols(reader, writer, location);
                    }
                    case RECORD: {
                        SchemaCompatibilityResult nameCheck = this.checkSchemaNames(reader, writer, location);
                        if (nameCheck.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                            return nameCheck;
                        }
                        return this.checkReaderWriterRecordFields(reader, writer, location);
                    }
                    case UNION: {
                        int i = 0;
                        for (Schema writerBranch : writer.getTypes()) {
                            location.push(Integer.toString(i));
                            SchemaCompatibilityResult compatibility = this.getCompatibility(reader, writerBranch);
                            if (compatibility.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                                String message = String.format("reader union lacking writer type: %s", writerBranch.getType());
                                return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.MISSING_UNION_BRANCH, reader, writer, message, location);
                            }
                            location.pop();
                            ++i;
                        }
                        return SchemaCompatibilityResult.compatible();
                    }
                }
                throw new AvroRuntimeException("Unknown schema type: " + reader.getType());
            }
            if (writer.getType() == Schema.Type.UNION) {
                int i = 0;
                for (Schema s : writer.getTypes()) {
                    location.push(Integer.toString(i));
                    SchemaCompatibilityResult result = this.getCompatibility(reader, s);
                    if (result.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                        return result;
                    }
                    location.pop();
                }
                return SchemaCompatibilityResult.compatible();
            }
            switch (reader.getType()) {
                case NULL: {
                    return this.typeMismatch(reader, writer, location);
                }
                case BOOLEAN: {
                    return this.typeMismatch(reader, writer, location);
                }
                case INT: {
                    return this.typeMismatch(reader, writer, location);
                }
                case LONG: {
                    return writer.getType() == Schema.Type.INT ? SchemaCompatibilityResult.compatible() : this.typeMismatch(reader, writer, location);
                }
                case FLOAT: {
                    return writer.getType() == Schema.Type.INT || writer.getType() == Schema.Type.LONG ? SchemaCompatibilityResult.compatible() : this.typeMismatch(reader, writer, location);
                }
                case DOUBLE: {
                    return writer.getType() == Schema.Type.INT || writer.getType() == Schema.Type.LONG || writer.getType() == Schema.Type.FLOAT ? SchemaCompatibilityResult.compatible() : this.typeMismatch(reader, writer, location);
                }
                case BYTES: {
                    return writer.getType() == Schema.Type.STRING ? SchemaCompatibilityResult.compatible() : this.typeMismatch(reader, writer, location);
                }
                case STRING: {
                    return writer.getType() == Schema.Type.BYTES ? SchemaCompatibilityResult.compatible() : this.typeMismatch(reader, writer, location);
                }
                case ARRAY: {
                    return this.typeMismatch(reader, writer, location);
                }
                case MAP: {
                    return this.typeMismatch(reader, writer, location);
                }
                case FIXED: {
                    return this.typeMismatch(reader, writer, location);
                }
                case ENUM: {
                    return this.typeMismatch(reader, writer, location);
                }
                case RECORD: {
                    return this.typeMismatch(reader, writer, location);
                }
                case UNION: {
                    for (Schema readerBranch : reader.getTypes()) {
                        SchemaCompatibilityResult compatibility = this.getCompatibility(readerBranch, writer);
                        if (compatibility.getCompatibility() != SchemaCompatibilityType.COMPATIBLE) continue;
                        return SchemaCompatibilityResult.compatible();
                    }
                    String message = String.format("reader union lacking writer type: %s", writer.getType());
                    return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.MISSING_UNION_BRANCH, reader, writer, message, location);
                }
            }
            throw new AvroRuntimeException("Unknown schema type: " + reader.getType());
        }

        private SchemaCompatibilityResult checkReaderWriterRecordFields(Schema reader, Schema writer, Stack<String> location) {
            location.push("fields");
            for (Schema.Field readerField : reader.getFields()) {
                location.push(Integer.toString(readerField.pos()));
                Schema.Field writerField = AvroSchemaValidator.lookupWriterField(writer, readerField);
                Schema readerFieldSchema = readerField.schema();
                if (writerField == null) {
                    if (readerField.defaultVal() == null && !this.isUnionWithFirstTypeAsNull(readerFieldSchema)) {
                        String message = String.format("Reader schema missing default value for field: %s", readerField.name());
                        return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.READER_FIELD_MISSING_DEFAULT_VALUE, reader, writer, message, location);
                    }
                } else {
                    SchemaCompatibilityResult compatibility = this.getCompatibility("type", readerFieldSchema, writerField.schema(), location);
                    if (compatibility.getCompatibility() == SchemaCompatibilityType.INCOMPATIBLE) {
                        return compatibility;
                    }
                }
                location.pop();
            }
            location.pop();
            return SchemaCompatibilityResult.compatible();
        }

        private boolean isUnionWithFirstTypeAsNull(Schema readerFieldSchema) {
            return readerFieldSchema.getType() == Schema.Type.UNION && ((Schema)readerFieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL;
        }

        private SchemaCompatibilityResult checkReaderEnumContainsAllWriterEnumSymbols(Schema reader, Schema writer, Stack<String> location) {
            location.push("symbols");
            TreeSet symbols = new TreeSet(writer.getEnumSymbols());
            symbols.removeAll(reader.getEnumSymbols());
            if (!symbols.isEmpty()) {
                return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.MISSING_ENUM_SYMBOLS, reader, writer, ((Object)symbols).toString(), location);
            }
            location.pop();
            return SchemaCompatibilityResult.compatible();
        }

        private SchemaCompatibilityResult checkFixedSize(Schema reader, Schema writer, Stack<String> location) {
            location.push("size");
            int actual = reader.getFixedSize();
            int expected = writer.getFixedSize();
            if (actual != expected) {
                String message = String.format("expected: %d, found: %d", expected, actual);
                return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.FIXED_SIZE_MISMATCH, reader, writer, message, location);
            }
            location.pop();
            return SchemaCompatibilityResult.compatible();
        }

        private SchemaCompatibilityResult checkSchemaNames(Schema reader, Schema writer, Stack<String> location) {
            location.push("name");
            if (!AvroSchemaValidator.schemaNameEquals(reader, writer)) {
                String message = String.format("expected: %s", writer.getFullName());
                return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.NAME_MISMATCH, reader, writer, message, location);
            }
            location.pop();
            return SchemaCompatibilityResult.compatible();
        }

        private SchemaCompatibilityResult typeMismatch(Schema reader, Schema writer, Stack<String> location) {
            String message = String.format("reader type: %s not compatible with writer type: %s", reader.getType(), writer.getType());
            return SchemaCompatibilityResult.incompatible(SchemaIncompatibilityType.TYPE_MISMATCH, reader, writer, message, location);
        }
    }

    private static final class ReaderWriter {
        private final Schema reader;
        private final Schema writer;

        public ReaderWriter(Schema reader, Schema writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public Schema getReader() {
            return this.reader;
        }

        public Schema getWriter() {
            return this.writer;
        }

        public int hashCode() {
            return System.identityHashCode(this.reader) ^ System.identityHashCode(this.writer);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReaderWriter)) {
                return false;
            }
            ReaderWriter that = (ReaderWriter)obj;
            return this.reader == that.reader && this.writer == that.writer;
        }

        public String toString() {
            return String.format("ReaderWriter{reader:%s, writer:%s}", this.reader, this.writer);
        }
    }
}

