/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.retry;

import com.hortonworks.registries.schemaregistry.retry.block.RetryableBlock;
import com.hortonworks.registries.schemaregistry.retry.policy.BackoffPolicy;
import com.hortonworks.registries.schemaregistry.retry.policy.NOOPBackoffPolicy;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RetryExecutor.class);
    private BackoffPolicy backoffPolicy;
    private Class<? extends RuntimeException> exceptionClass;

    private RetryExecutor(BackoffPolicy backoffPolicy, Class<? extends RuntimeException> exceptionClass) {
        this.backoffPolicy = backoffPolicy;
        this.exceptionClass = exceptionClass;
    }

    public <T> T execute(RetryableBlock<T> retryableBlock) {
        RuntimeException exception = null;
        int attemptNumber = 1;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                LOG.debug("Executing the retryable block with attempt number : {} and elapsed time : {} ms", (Object)attemptNumber, (Object)(System.currentTimeMillis() - startTime));
                return retryableBlock.run();
            }
            catch (Exception e) {
                if (!e.getClass().equals(this.exceptionClass)) {
                    throw e;
                }
                exception = (RuntimeException)e;
                if (this.backoffPolicy.mayBeSleep(attemptNumber++, System.currentTimeMillis() - startTime)) continue;
                LOG.debug("Giving up on executing the retryable block after attempt number : {} and elapsed time : {} ms", (Object)attemptNumber, (Object)(System.currentTimeMillis() - startTime));
                throw exception;
            }
            break;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryExecutor that = (RetryExecutor)o;
        return Objects.equals(this.backoffPolicy, that.backoffPolicy) && Objects.equals(this.exceptionClass, that.exceptionClass);
    }

    public int hashCode() {
        return Objects.hash(this.backoffPolicy, this.exceptionClass);
    }

    public String toString() {
        return "RetryExecutor{backoffPolicy=" + this.backoffPolicy + ", exceptionClass=" + this.exceptionClass + '}';
    }

    public static class Builder {
        private BackoffPolicy policy = new NOOPBackoffPolicy();
        private Class<? extends RuntimeException> exceptionClass = RuntimeException.class;

        public Builder backoffPolicy(BackoffPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder retryOnException(Class<? extends RuntimeException> e) {
            this.exceptionClass = e;
            return this;
        }

        public RetryExecutor build() {
            return new RetryExecutor(this.policy, this.exceptionClass);
        }
    }
}

