/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.retry.policy;

import java.util.Map;

public abstract class BackoffPolicy {
    protected Long sleepTimeMs;
    protected Integer maxAttempts;
    protected Long timeoutMs;
    public static final String SLEEP_TIME_MS = "sleepTimeMs";
    public static final String MAX_ATTEMPTS = "maxAttempts";
    public static final String TIMEOUT_MS = "timeoutMs";

    protected BackoffPolicy() {
    }

    protected BackoffPolicy(Long sleepTimeMs, Integer maxAttempts, Long timeoutMs) {
        this.sleepTimeMs = sleepTimeMs;
        this.maxAttempts = maxAttempts;
        this.timeoutMs = timeoutMs;
    }

    public abstract void init(Map<String, Object> var1);

    public boolean mayBeSleep(int attemptNumber, long timeElapsed) {
        if (attemptNumber >= this.maxAttempts) {
            return false;
        }
        long sleepTime = this.sleepTime(attemptNumber, timeElapsed);
        if (sleepTime + timeElapsed > this.timeoutMs) {
            return false;
        }
        this.sleep(sleepTime);
        return true;
    }

    abstract long sleepTime(int var1, long var2);

    protected void sleep(long sleepTimeMs) {
        try {
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

