/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.retry.policy;

import com.google.common.annotations.VisibleForTesting;
import com.hortonworks.registries.schemaregistry.retry.policy.BackoffPolicy;
import java.util.Map;

public class ExponentialBackoffPolicy
extends BackoffPolicy {
    private static final long DEFAULT_SLEEP_TIME_MS = 1000L;
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final long DEFAULT_TIMEOUT_MS = 90000L;

    public ExponentialBackoffPolicy() {
    }

    public ExponentialBackoffPolicy(Long sleepTimeMs, Integer maxAttempts, Long maxSleepTimeMs) {
        super(sleepTimeMs, maxAttempts, maxSleepTimeMs);
    }

    @Override
    public void init(Map<String, Object> properties) {
        this.sleepTimeMs = Long.valueOf(properties.getOrDefault("sleepTimeMs", 1000L).toString());
        this.maxAttempts = Integer.valueOf(properties.getOrDefault("maxAttempts", 5).toString());
        this.timeoutMs = Long.valueOf(properties.getOrDefault("timeoutMs", 90000L).toString());
    }

    @Override
    @VisibleForTesting
    long sleepTime(int attemptNumber, long timeElapsed) {
        return (long)((double)this.sleepTimeMs.longValue() * Math.pow(2.0, attemptNumber - 1));
    }

    public String toString() {
        return "ExponentialBackoffPolicy{, sleepTimeMs=" + this.sleepTimeMs + ", maxAttempts=" + this.maxAttempts + ", timeoutMs=" + this.timeoutMs + '}';
    }
}

