/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.state;

import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.state.AbstractInbuiltSchemaLifecycleState;
import com.hortonworks.registries.schemaregistry.state.CustomSchemaStateExecutor;
import com.hortonworks.registries.schemaregistry.state.SchemaLifecycleException;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleContext;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateAction;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateMachine;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateTransition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultCustomSchemaStateExecutor
implements CustomSchemaStateExecutor {
    private InReviewState inReviewState;
    private SchemaVersionLifecycleState successState;
    private SchemaVersionLifecycleState retryState;

    @Override
    public void init(SchemaVersionLifecycleStateMachine.Builder builder, Byte successStateId, Byte retryStateId, Map<String, ?> props) {
        this.successState = builder.getStates().get(successStateId);
        this.retryState = builder.getStates().get(retryStateId);
        this.inReviewState = new InReviewState(this.successState);
        builder.register(this.inReviewState);
        for (Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> pair : this.inReviewState.getTransitionActions()) {
            builder.transition((SchemaVersionLifecycleStateTransition)pair.getLeft(), (SchemaVersionLifecycleStateAction)pair.getRight());
        }
    }

    @Override
    public void executeReviewState(SchemaVersionLifecycleContext schemaVersionLifecycleContext) throws SchemaLifecycleException, SchemaNotFoundException {
        schemaVersionLifecycleContext.setState(this.inReviewState);
        schemaVersionLifecycleContext.updateSchemaVersionState();
    }

    private static final class InReviewState
    extends AbstractInbuiltSchemaLifecycleState {
        private final List<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> transitionActionPair;

        private InReviewState(SchemaVersionLifecycleState targetState) {
            super("InReview", (byte)32, "Finish the schema version.");
            SchemaVersionLifecycleStateTransition stateTransition = new SchemaVersionLifecycleStateTransition(this.getId(), targetState.getId(), "FinishReview", "Finish schema review process");
            SchemaVersionLifecycleStateAction stateAction = context -> {
                context.setState(targetState);
                try {
                    context.updateSchemaVersionState();
                }
                catch (SchemaNotFoundException e) {
                    throw new SchemaLifecycleException(e);
                }
            };
            this.transitionActionPair = Collections.singletonList(Pair.of((Object)stateTransition, (Object)stateAction));
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return this.transitionActionPair;
        }

        @Override
        public String toString() {
            return "FinishReviewState{" + super.toString() + "}";
        }
    }
}

