/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.AclHeaderConvertor;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.CRC64;
import com.obs.services.internal.utils.Mimetypes;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.xml.OBSXMLBuilder;
import com.obs.services.model.ActionEnum;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.ExtensionBucketPermissionEnum;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.GetSnapshottableDirListRequest;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.fs.ContentSummaryFsRequest;
import com.obs.services.model.fs.ListContentSummaryFsRequest;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.NewBucketRequest;
import com.obs.services.model.fs.WriteFileRequest;
import com.obs.services.model.fusion.RedundancyTypeEnum;
import com.obs.services.model.symlink.PutSymlinkRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import okhttp3.RequestBody;

public abstract class RequestConvertor
extends AclHeaderConvertor {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    protected AbstractRequestConvertor.TransResult transListVersionsRequest(ListVersionsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.VERSIONS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            params.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            params.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(request.getMaxKeys()));
        }
        if (request.getKeyMarker() != null) {
            params.put("key-marker", request.getKeyMarker());
        }
        if (request.getVersionIdMarker() != null) {
            params.put("version-id-marker", request.getVersionIdMarker());
        }
        if (request.getEncodingType() != null) {
            params.put("encoding-type", request.getEncodingType());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).listTimeoutHeader(), String.valueOf(request.getListTimeout()));
        }
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected AbstractRequestConvertor.TransResult transInitiateMultipartUploadRequest(InitiateMultipartUploadRequest request) throws ServiceException {
        Object contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders(request.getBucketName());
        IConvertor iconvertor = this.getIConvertor(request.getBucketName());
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        this.selectAllowedHeader(headers, objectMetadata);
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (ServiceUtils.isValid(objectMetadata.getWebSiteRedirectLocation())) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (ServiceUtils.isValid(request.getSuccessRedirectLocation())) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        if (request.getExpires() > 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        this.setBaseHeaderFromMetadata(request.getBucketName(), headers, objectMetadata);
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        String contentTypeStr = contentType.toString().trim();
        headers.put("Content-Type", contentTypeStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        if (request.getEncodingType() != null) {
            params.put("encoding-type", request.getEncodingType());
        }
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    private void selectAllowedHeader(Map<String, String> headers, ObjectMetadata objectMetadata) {
        for (Map.Entry<String, Object> entry : objectMetadata.getAllMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            if ((CAN_USE_STANDARD_HTTP_HEADERS.get() == null || CAN_USE_STANDARD_HTTP_HEADERS.get() != null && !((Boolean)CAN_USE_STANDARD_HTTP_HEADERS.get()).booleanValue()) && Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.ROOT))) continue;
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
    }

    protected void transExtensionPermissions(PutObjectBasicRequest request, Map<String, String> headers) {
        Set<ExtensionObjectPermissionEnum> extensionPermissionEnums = request.getAllGrantPermissions();
        if (!extensionPermissionEnums.isEmpty()) {
            for (ExtensionObjectPermissionEnum extensionPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(request.getBucketName(), extensionPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
    }

    protected void transSseHeaders(PutObjectBasicRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request.getSseCHeader()) {
            this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        } else if (null != request.getSseKmsHeader()) {
            this.transSseKmsHeaders(request.getSseKmsHeader(), headers, iheaders, request.getBucketName());
        }
    }

    protected void transSseCHeaders(SseCHeader ssecHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (ssecHeader == null) {
            return;
        }
        String sseCAlgorithm = ssecHeader.getSSEAlgorithm().getCode();
        this.putHeader(headers, iheaders.sseCHeader(), ServiceUtils.toValid(sseCAlgorithm));
        if (ssecHeader.getSseCKeyBase64() != null) {
            try {
                this.putHeader(headers, iheaders.sseCKeyHeader(), ssecHeader.getSseCKeyBase64());
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(ssecHeader.getSseCKeyBase64()))));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
        if (null != ssecHeader.getSseCKey() && ssecHeader.getSseCKey().length > 0) {
            try {
                byte[] data = ssecHeader.getSseCKey();
                this.putHeader(headers, iheaders.sseCKeyHeader(), ServiceUtils.toBase64(data));
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
    }

    protected AbstractRequestConvertor.TransResult transCreateBucketRequest(CreateBucketRequest request) throws ServiceException {
        String headerPrefix;
        Set<ExtensionBucketPermissionEnum> extensionPermissionEnums;
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor convertor = this.getIConvertor(request.getBucketName());
        if (request.getBucketStorageClass() != null) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).defaultStorageClassHeader(), convertor.transStorageClass(request.getBucketStorageClass()));
        }
        if (request.getEpid() != null) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).epidHeader(), request.getEpid());
        }
        if (request instanceof NewBucketRequest) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).fsFileInterfaceHeader(), "Enabled");
        }
        if (null != request.getBucketType() && BucketTypeEnum.PFS == request.getBucketType()) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).fsFileInterfaceHeader(), "Enabled");
        }
        if (request.getAvailableZone() != null) {
            this.putHeader(headers, this.getIHeaders(request.getBucketName()).azRedundancyHeader(), request.getAvailableZone().getCode());
        }
        if (!(extensionPermissionEnums = request.getAllGrantPermissions()).isEmpty()) {
            for (ExtensionBucketPermissionEnum extensionBucketPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionBucketPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(request.getBucketName(), extensionBucketPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
        if (request.getExtensionHeaderMap() != null) {
            for (Map.Entry entry : request.getExtensionHeaderMap().entrySet()) {
                this.putHeader(headers, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        String string = headerPrefix = this.getProviderCredentials().getLocalAuthType(request.getBucketName()) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-";
        if (request.getBucketRedundancy() == RedundancyTypeEnum.FUSION) {
            this.putHeader(headers, headerPrefix + "bucket-redundancy", String.valueOf(RedundancyTypeEnum.FUSION.getCode()));
        }
        if (request.getFusionAllowUpgrade() != ActionEnum.DEFAULT) {
            this.putHeader(headers, headerPrefix + "fusion-allow-upgrade", String.valueOf(request.getFusionAllowUpgrade().getCode()));
        }
        if (request.getFusionAllowAlternative() != ActionEnum.DEFAULT) {
            this.putHeader(headers, headerPrefix + "fusion-allow-alternative", String.valueOf(request.getFusionAllowAlternative().getCode()));
        }
        String string2 = "application/xml";
        headers.put("Content-Type", string2);
        AbstractRequestConvertor.TransResult result = new AbstractRequestConvertor.TransResult(headers);
        if (ServiceUtils.isValid(request.getLocation())) {
            String configXml = convertor.transBucketLoction(request.getLocation());
            headers.put("Content-Length", String.valueOf(configXml.length()));
            RequestBody requestEntity = this.createRequestBody(string2, configXml);
            result.setBody(requestEntity);
        }
        return result;
    }

    protected RestoreObjectRequest.RestoreObjectStatus transRestoreObjectResultToRestoreObjectStatus(RestoreObjectResult result) {
        RestoreObjectRequest.RestoreObjectStatus ret = RestoreObjectRequest.RestoreObjectStatus.valueOf(result.getStatusCode());
        ret.setResponseHeaders(result.getResponseHeaders());
        ret.setStatusCode(result.getStatusCode());
        return ret;
    }

    protected CRC64 tryAddCrc64ForPutObjectRequest(PutObjectRequest request, IHeaders iheaders, Map<String, String> headers) {
        String crc64UserHeaderValue;
        HashMap<String, String> userHeaders = request.getUserHeaders();
        String crc64HeaderKey = iheaders.headerPrefix() + "checksum-crc64ecma";
        if (userHeaders != null && null != (crc64UserHeaderValue = userHeaders.get(crc64HeaderKey))) {
            log.warn("userHeader contains " + crc64HeaderKey + ", value is " + crc64UserHeaderValue + ", sdk crc64 calculation skipped.");
        } else if (!request.isNeedCalculateCRC64()) {
            log.debug("Request not set 'needCalculateCRC64'");
        } else {
            if (request.getFile() != null) {
                try {
                    CRC64 crc64 = CRC64.fromFile(request.getFile());
                    if (request instanceof AppendObjectRequest && ((AppendObjectRequest)request).getCrc64BeforeAppend() != null) {
                        AppendObjectRequest appendObjectRequest = (AppendObjectRequest)request;
                        String crc64BeforeAppend = appendObjectRequest.getCrc64BeforeAppend();
                        long crc64BeforeAppendValue = CRC64.fromString(crc64BeforeAppend);
                        crc64.setValue(CRC64.combine(crc64BeforeAppendValue, crc64.getValue(), request.getFile().length()));
                    }
                    long crc64InLong = crc64.getValue();
                    String crc64InUnsignedString = crc64.toString();
                    headers.put(crc64HeaderKey, crc64InUnsignedString);
                    log.info("crc64InLong:" + crc64InLong + ", crc64InUnsignedString:" + crc64InUnsignedString);
                    return crc64;
                }
                catch (IOException | NumberFormatException e) {
                    throw new ObsException("Failed to calculate crc64, Error :", e);
                }
            }
            log.error("sdk crc64 calculation is valid only when PutObjectRequest.getFile() is not null.");
        }
        return null;
    }

    protected AbstractRequestConvertor.TransResult transPutObjectRequest(PutObjectRequest request) throws ServiceException {
        Object contentLength;
        Object contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders(request.getBucketName());
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        this.setBaseHeaderFromMetadata(request.getBucketName(), headers, objectMetadata);
        if (request.getExpires() >= 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        if ((contentLength = objectMetadata.getContentLength()) == null) {
            contentLength = objectMetadata.getValue("Content-Length");
        }
        long contentLengthValue = contentLength == null ? -1L : Long.parseLong(contentLength.toString());
        CRC64 crc64 = this.tryAddCrc64ForPutObjectRequest(request, iheaders, headers);
        if (request.getFile() != null) {
            if ("application/octet-stream".equals(contentType)) {
                contentType = Mimetypes.getInstance().getMimetype(request.getFile());
            }
            long fileSize = request.getFile().length();
            try {
                request.setInput(new FileInputStream(request.getFile()));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File does not exist");
            }
            contentLengthValue = this.getContentLengthFromFile(request, contentLengthValue, fileSize);
        }
        String contentTypeStr = contentType.toString().trim();
        headers.put("Content-Type", contentTypeStr);
        if (contentLengthValue > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(contentLengthValue));
        }
        if (request.getInput() != null && request.getProgressListener() != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(contentLengthValue, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
            request.setInput(new ProgressInputStream(request.getInput(), progressManager));
        }
        RepeatableRequestEntity body = request.getInput() == null ? null : new RepeatableRequestEntity(request.getInput(), contentTypeStr, contentLengthValue, this.obsProperties);
        AbstractRequestConvertor.TransResult transResult = new AbstractRequestConvertor.TransResult(headers, body);
        transResult.setCalculatedCrc64(crc64);
        return transResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getContentLengthFromFile(PutObjectRequest request, long contentLengthValue, long fileSize) {
        if (request.getOffset() > 0L && request.getOffset() < fileSize) {
            contentLengthValue = contentLengthValue > 0L && contentLengthValue <= fileSize - request.getOffset() ? contentLengthValue : fileSize - request.getOffset();
            try {
                long skipByte = request.getInput().skip(request.getOffset());
                if (!log.isDebugEnabled()) return contentLengthValue;
                log.debug("Skip " + skipByte + " bytes; offset : " + request.getOffset());
                return contentLengthValue;
            }
            catch (IOException e) {
                ServiceUtils.closeStream(request.getInput());
                throw new ServiceException(e);
            }
        } else {
            if (contentLengthValue < 0L) return fileSize;
            if (contentLengthValue <= fileSize) return contentLengthValue;
            return fileSize;
        }
    }

    private void setBaseHeaderFromMetadata(String bucketName, Map<String, String> headers, ObjectMetadata objectMetadata) {
        IConvertor iconvertor = this.getIConvertor(bucketName);
        IHeaders iheaders = this.getIHeaders(bucketName);
        this.selectAllowedHeader(headers, objectMetadata);
        if (ServiceUtils.isValid(objectMetadata.getContentMd5())) {
            headers.put("Content-MD5", objectMetadata.getContentMd5().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentEncoding())) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentDisposition())) {
            headers.put("Content-Disposition", objectMetadata.getContentDisposition().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getCacheControl())) {
            headers.put("Cache-Control", objectMetadata.getCacheControl().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentLanguage())) {
            headers.put("Content-Language", objectMetadata.getContentLanguage().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getExpires())) {
            headers.put("Expires", objectMetadata.getExpires().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getCrc64())) {
            headers.put(this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-checksum-crc64ecma", objectMetadata.getCrc64().trim());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
    }

    protected AbstractRequestConvertor.TransResult transWriteFileRequest(WriteFileRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transPutObjectRequest(request);
        if (request.getPosition() > 0L) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SpecialParamEnum.MODIFY.getOriginalStringCode(), "");
            params.put("position", String.valueOf(request.getPosition()));
            result.setParams(params);
        }
        return result;
    }

    protected AbstractRequestConvertor.TransResult transModifyObjectRequest(ModifyObjectRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transPutObjectRequest(request);
        if (request.getPosition() > 0L) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SpecialParamEnum.MODIFY.getOriginalStringCode(), "");
            params.put("position", String.valueOf(request.getPosition()));
            result.setParams(params);
        }
        return result;
    }

    protected AbstractRequestConvertor.TransResult transAppendObjectRequest(AppendObjectRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transPutObjectRequest(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.APPEND.getOriginalStringCode(), "");
        params.put("position", String.valueOf(request.getPosition()));
        result.setParams(params);
        return result;
    }

    protected AbstractRequestConvertor.TransResult transCopyObjectRequest(CopyObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor iconvertor = this.getIConvertor(request.getBucketName());
        IHeaders iheaders = this.getIHeaders(request.getBucketName());
        ObjectMetadata objectMetadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata();
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isReplaceMetadata() ? "REPLACE" : "COPY");
        if (request.isReplaceMetadata()) {
            Object contentType;
            objectMetadata.getAllMetadata().remove(iheaders.requestIdHeader());
            objectMetadata.getAllMetadata().remove(iheaders.requestId2Header());
            for (Map.Entry<String, Object> entry : objectMetadata.getAllMetadata().entrySet()) {
                String key = entry.getKey();
                if (!ServiceUtils.isValid(key) || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase(Locale.ROOT))) continue;
                headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
            }
            Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
            if (contentType == null) {
                contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
            }
            headers.put("Content-Type", contentType.toString().trim());
        }
        this.setBaseHeaderFromMetadata(request.getBucketName(), headers, objectMetadata);
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        this.transConditionCopyHeaders(request, headers, iheaders);
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        return new AbstractRequestConvertor.TransResult(headers);
    }

    protected void transSseCSourceHeaders(SseCHeader sseCHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (sseCHeader != null) {
            String algorithm = sseCHeader.getSSEAlgorithm().getCode();
            this.putHeader(headers, iheaders.copySourceSseCHeader(), ServiceUtils.toValid(algorithm));
            if (sseCHeader.getSseCKeyBase64() != null) {
                try {
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), sseCHeader.getSseCKeyBase64());
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(sseCHeader.getSseCKeyBase64()))));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
            if (null != sseCHeader.getSseCKey() && sseCHeader.getSseCKey().length > 0) {
                try {
                    byte[] data = sseCHeader.getSseCKey();
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), ServiceUtils.toBase64(data));
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
        }
    }

    protected void transConditionCopyHeaders(CopyObjectRequest request, Map<String, String> headers, IHeaders iheaders) {
        if (request.getIfModifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfModifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfUnmodifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfMatchHeader(), request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfNoneMatchHeader(), request.getIfNoneMatchTag().trim());
        }
    }

    protected AbstractRequestConvertor.TransResult transGetObjectRequest(GetObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders(request.getBucketName()));
        this.transConditionGetObjectHeaders(request, headers);
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        this.transRangeHeader(request, headers);
        HashMap<String, String> params = new HashMap<String, String>();
        this.transGetObjectParams(request, params);
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected void transRangeHeader(GetObjectRequest request, Map<String, String> headers) {
        String start = "";
        String end = "";
        if (null != request.getRangeStart()) {
            ServiceUtils.assertParameterNotNegative(request.getRangeStart(), "start range should not be negative.");
            start = String.valueOf(request.getRangeStart());
        }
        if (null != request.getRangeEnd()) {
            ServiceUtils.assertParameterNotNegative(request.getRangeEnd(), "end range should not be negative.");
            end = String.valueOf(request.getRangeEnd());
        }
        if (null != request.getRangeStart() && null != request.getRangeEnd() && request.getRangeStart() > request.getRangeEnd()) {
            throw new IllegalArgumentException("start must be less than end.");
        }
        if (!"".equals(start) || !"".equals(end)) {
            String range = String.format("bytes=%s-%s", start, end);
            headers.put("Range", range);
        }
    }

    protected void transGetObjectParams(GetObjectRequest request, Map<String, String> params) {
        if (null != request.getReplaceMetadata()) {
            if (ServiceUtils.isValid(request.getReplaceMetadata().getCacheControl())) {
                params.put("response-cache-control", request.getReplaceMetadata().getCacheControl());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentDisposition())) {
                params.put("response-content-disposition", request.getReplaceMetadata().getContentDisposition());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentEncoding())) {
                params.put("response-content-encoding", request.getReplaceMetadata().getContentEncoding());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentLanguage())) {
                params.put("response-content-language", request.getReplaceMetadata().getContentLanguage());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentType())) {
                params.put("response-content-type", request.getReplaceMetadata().getContentType());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getExpires())) {
                params.put("response-expires", request.getReplaceMetadata().getExpires());
            }
        }
        if (ServiceUtils.isValid(request.getImageProcess())) {
            params.put("x-image-process", request.getImageProcess());
        }
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        if (request.getCacheOption() != null) {
            String cacheControl = request.getCacheOption().getCode() + ", ttl=" + request.getTtl();
            params.put("x-cache-control", cacheControl);
        }
    }

    protected void transConditionGetObjectHeaders(GetObjectRequest request, Map<String, String> headers) {
        if (request.getIfModifiedSince() != null) {
            headers.put("If-Modified-Since", ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            headers.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            headers.put("If-Match", request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            headers.put("If-None-Match", request.getIfNoneMatchTag().trim());
        }
        if (!request.isAutoUnzipResponse()) {
            headers.put("Accept-Encoding", "identity");
        }
    }

    protected AbstractRequestConvertor.TransResult transSetObjectMetadataRequest(SetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders(request.getBucketName());
        IConvertor iconvertor = this.getIConvertor(request.getBucketName());
        for (Map.Entry<String, String> entry : request.getAllUserMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            headers.put(key, entry.getValue() == null ? "" : entry.getValue());
        }
        if (request.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(request.getObjectStorageClass()));
        }
        if (request.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), request.getWebSiteRedirectLocation());
        }
        if (request.getContentDisposition() != null) {
            this.putHeader(headers, "Content-Disposition", request.getContentDisposition());
        }
        if (request.getContentEncoding() != null) {
            this.putHeader(headers, "Content-Encoding", request.getContentEncoding());
        }
        if (request.getContentLanguage() != null) {
            this.putHeader(headers, "Content-Language", request.getContentLanguage());
        }
        if (request.getContentType() != null) {
            this.putHeader(headers, "Content-Type", request.getContentType());
        }
        if (request.getCacheControl() != null) {
            this.putHeader(headers, "Cache-Control", request.getCacheControl());
        }
        if (request.getExpires() != null) {
            this.putHeader(headers, "Expires", request.getExpires());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isRemoveUnset() ? "REPLACE" : "REPLACE_NEW");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.METADATA.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected AbstractRequestConvertor.TransResult transCopyPartRequest(CopyPartRequest request) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders(request.getBucketName());
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        if (request.getByteRangeStart() != null) {
            String rangeEnd = request.getByteRangeEnd() != null ? String.valueOf(request.getByteRangeEnd()) : "";
            String range = String.format("bytes=%s-%s", request.getByteRangeStart(), rangeEnd);
            this.putHeader(headers, iheaders.copySourceRangeHeader(), range);
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transSseCHeaders(request.getSseCHeaderDestination(), headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected AbstractRequestConvertor.TransResult transListObjectsRequest(ListObjectsRequest listObjectsRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(listObjectsRequest, headers, this.getIHeaders(listObjectsRequest.getBucketName()));
        if (listObjectsRequest.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders(listObjectsRequest.getBucketName()).listTimeoutHeader(), String.valueOf(listObjectsRequest.getListTimeout()));
        }
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected NewTransResult transGetSnapshottableDirListRequest(GetSnapshottableDirListRequest getSnapshottableDirListRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.OBS_SNAPSHOT_ROOT.getOriginalStringCode(), "");
        if (getSnapshottableDirListRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(getSnapshottableDirListRequest.getMaxKeys()));
        }
        if (getSnapshottableDirListRequest.getMarker() != null) {
            params.put("marker", getSnapshottableDirListRequest.getMarker());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(getSnapshottableDirListRequest, headers, this.getIHeaders(getSnapshottableDirListRequest.getBucketName()));
        NewTransResult result = this.transRequest(getSnapshottableDirListRequest);
        result.setParams(params);
        result.setHeaders(headers);
        return result;
    }

    protected AbstractRequestConvertor.TransResult transListContentSummaryRequest(ListContentSummaryRequest listContentSummaryRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (listContentSummaryRequest.getPrefix() != null) {
            params.put("prefix", listContentSummaryRequest.getPrefix());
        }
        if (listContentSummaryRequest.getDelimiter() != null) {
            params.put("delimiter", listContentSummaryRequest.getDelimiter());
        }
        if (listContentSummaryRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(listContentSummaryRequest.getMaxKeys()));
        }
        if (listContentSummaryRequest.getMarker() != null) {
            params.put("marker", listContentSummaryRequest.getMarker());
        }
        params.put(SpecialParamEnum.LISTCONTENTSUMMARY.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(listContentSummaryRequest, headers, this.getIHeaders(listContentSummaryRequest.getBucketName()));
        if (listContentSummaryRequest.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders(listContentSummaryRequest.getBucketName()).listTimeoutHeader(), String.valueOf(listContentSummaryRequest.getListTimeout()));
        }
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected AbstractRequestConvertor.TransResult transListContentSummaryFsRequest(ListContentSummaryFsRequest listContentSummaryFsRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.LISTCONTENTSUMMARYFS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String sbXml = "";
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("MultiListContentSummary");
            builder.elem("MaxKeys").text(String.valueOf(listContentSummaryFsRequest.getMaxKeys()));
            if (listContentSummaryFsRequest.getDirLayers().size() > 0) {
                for (ListContentSummaryFsRequest.DirLayer dir : listContentSummaryFsRequest.getDirLayers()) {
                    OBSXMLBuilder builderDir = OBSXMLBuilder.create("Dir");
                    builderDir.elem("Key").text(dir.getKey());
                    if (ServiceUtils.isValid(dir.getMarker())) {
                        builderDir.elem("Marker").text(dir.getMarker());
                    }
                    if (dir.getInode() != 0L) {
                        builderDir.elem("Inode").text(String.valueOf(dir.getInode()));
                    }
                    builder.importXMLBuilder(builderDir);
                }
            }
            sbXml = builder.asString();
        }
        catch (FactoryConfigurationError | ParserConfigurationException | TransformerException e) {
            throw new ServiceException("Failed to build XML document for MultiListContentSummary", e);
        }
        this.putHeader(headers, (this.getProviderCredentials().getLocalAuthType(listContentSummaryFsRequest.getBucketName()) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "fs-summary-dir-list", ServiceUtils.toBase64(sbXml.getBytes(StandardCharsets.UTF_8)));
        this.transRequestPaymentHeaders(listContentSummaryFsRequest, headers, this.getIHeaders(listContentSummaryFsRequest.getBucketName()));
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected AbstractRequestConvertor.TransResult transGetContentSummaryFs(ContentSummaryFsRequest contentSummaryFsRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.GETCONTENTSUMMARY.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(contentSummaryFsRequest, headers, this.getIHeaders(contentSummaryFsRequest.getBucketName()));
        return new AbstractRequestConvertor.TransResult(headers, params, null);
    }

    protected CRC64 tryAddCrc64ForUploadPartRequest(UploadPartRequest request, IHeaders iheaders, Map<String, String> headers) {
        String crc64UserHeaderValue;
        HashMap<String, String> userHeaders = request.getUserHeaders();
        String crc64HeaderKey = iheaders.headerPrefix() + "checksum-crc64ecma";
        if (userHeaders != null && null != (crc64UserHeaderValue = userHeaders.get(crc64HeaderKey))) {
            log.warn("userHeader contains " + crc64HeaderKey + ", value is " + crc64UserHeaderValue + ", sdk crc64 calculation skipped.");
        } else if (!request.isNeedCalculateCRC64()) {
            log.debug("UploadPartRequest not set 'needCalculateCRC64'");
        } else {
            if (request.getFile() != null) {
                CRC64 cRC64;
                FileInputStream fileInputStream = new FileInputStream(request.getFile());
                try {
                    CRC64 crc64 = CRC64.fromInputStream(fileInputStream, request.getOffset(), request.getPartSize());
                    long crc64InLong = crc64.getValue();
                    String crc64InUnsignedString = crc64.toString();
                    headers.put(crc64HeaderKey, crc64InUnsignedString);
                    log.info("crc64InLong:" + crc64InLong + ", crc64InUnsignedString:" + crc64InUnsignedString);
                    cRC64 = crc64;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ServiceException("Failed to calculate crc64, Error :", e);
                    }
                }
                fileInputStream.close();
                return cRC64;
            }
            log.error("sdk crc64 calculation is valid only when PutObjectRequest.getFile() is not null.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractRequestConvertor.TransResult transUploadPartRequest(UploadPartRequest request) throws ServiceException {
        params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        headers = new HashMap<String, String>();
        iheaders = this.getIHeaders(request.getBucketName());
        if (ServiceUtils.isValid(request.getContentMd5())) {
            headers.put("Content-MD5", request.getContentMd5().trim());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        contentLength = -1L;
        crc64 = this.tryAddCrc64ForUploadPartRequest(request, iheaders, headers);
        if (null != request.getFile()) {
            fileSize = request.getFile().length();
            offset = request.getOffset() >= 0L && request.getOffset() < fileSize ? request.getOffset() : 0L;
            contentLength = partSize = request.getPartSize() != null && request.getPartSize() > 0L && request.getPartSize() <= fileSize - offset ? request.getPartSize() : fileSize - offset;
            try {
                if (request.isAttachMd5() && !ServiceUtils.isValid(request.getContentMd5())) {
                    headers.put("Content-MD5", ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(request.getFile()), partSize, offset)));
                }
                request.setInput(new FileInputStream(request.getFile()));
                skipByte = request.getInput().skip(offset);
                if (!RequestConvertor.log.isDebugEnabled()) ** GOTO lbl34
                RequestConvertor.log.debug("Skip " + skipByte + " bytes; offset : " + offset);
            }
            catch (Exception e) {
                ServiceUtils.closeStream(request.getInput());
                throw new ServiceException(e);
            }
        } else if (null != request.getInput() && request.getPartSize() != null && request.getPartSize() > 0L) {
            contentLength = request.getPartSize();
        }
lbl34:
        // 5 sources

        if (request.getInput() != null && request.getProgressManager() != null) {
            request.setInput(new ProgressInputStream(request.getInput(), request.getProgressManager()));
        } else if (request.getInput() != null && request.getProgressListener() != null) {
            progressManager = new SimpleProgressManager(contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
            request.setInput(new ProgressInputStream(request.getInput(), progressManager));
        }
        contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        headers.put("Content-Type", contentType);
        if (contentLength > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(contentLength));
        }
        body = request.getInput() == null ? null : new RepeatableRequestEntity(request.getInput(), contentType, contentLength, this.obsProperties);
        transResult = new AbstractRequestConvertor.TransResult(headers, params, body);
        transResult.setCalculatedCrc64(crc64);
        return transResult;
    }

    protected void transSseKmsHeaders(SseKmsHeader kmsHeader, Map<String, String> headers, IHeaders iheaders, String bucketName) {
        if (kmsHeader == null) {
            return;
        }
        String sseKmsEncryption = this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "aws:" + kmsHeader.getSSEAlgorithm().getCode() : kmsHeader.getSSEAlgorithm().getCode();
        this.putHeader(headers, iheaders.sseKmsHeader(), ServiceUtils.toValid(sseKmsEncryption));
        if (ServiceUtils.isValid(kmsHeader.getKmsKeyId())) {
            this.putHeader(headers, iheaders.sseKmsKeyHeader(), kmsHeader.getKmsKeyId());
        }
        if (ServiceUtils.isValid(kmsHeader.getProjectId())) {
            this.putHeader(headers, iheaders.sseKmsProjectIdHeader(), kmsHeader.getProjectId());
        }
    }

    protected void prepareSymlinkTargetHeader(String bucketName, Map<String, String> headers, String symlinkTarget) throws ServiceException {
        headers.put(this.getIHeaders(bucketName).headerPrefix() + "symlink-target", symlinkTarget);
    }

    protected NewTransResult transPutSymlinkRequest(PutSymlinkRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.SYM_LINK.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String bucketName = request.getBucketName();
        this.prepareRESTHeaderAcl(bucketName, headers, request.getAcl());
        this.prepareSymlinkTargetHeader(bucketName, headers, request.getSymlinkTarget());
        ObjectMetadata objectMetadata = Optional.ofNullable(request.getObjectMetadata()).orElseGet(ObjectMetadata::new);
        this.setBaseHeaderFromMetadata(bucketName, headers, objectMetadata);
        NewTransResult result = this.transObjectRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        return result;
    }
}

