/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.resource.ClasspathResource;

public class ClasspathResourceLoader
implements ResourceLoader {
    private String root = null;
    boolean autoCheck = false;
    protected String charset = "UTF-8";
    String functionRoot = "functions";
    GroupTemplate gt = null;
    String functionSuffix = "fn";
    ClassLoader classLoader = null;

    public ClasspathResourceLoader() {
        this.classLoader = this.getClass().getClassLoader();
        this.root = "";
    }

    public ClasspathResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.root = "";
    }

    public ClasspathResourceLoader(ClassLoader classLoader, String root) {
        this.classLoader = classLoader;
        this.root = root;
    }

    public ClasspathResourceLoader(ClassLoader classLoader, String root, String charset) {
        this(classLoader, root);
        this.charset = charset;
    }

    public ClasspathResourceLoader(String root) {
        this();
        this.root = root.equals("/") ? "" : root;
    }

    public ClasspathResourceLoader(String root, String charset) {
        this(root);
        this.charset = charset;
    }

    @Override
    public Resource getResource(String key) {
        ClasspathResource resource = new ClasspathResource(key, this.root + key, this);
        return resource;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isModified(Resource key) {
        if (this.autoCheck) {
            return key.isModified();
        }
        return false;
    }

    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    public void setAutoCheck(boolean autoCheck) {
        this.autoCheck = autoCheck;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public void init(GroupTemplate gt) {
        File fnRoot;
        String temp;
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        if (resourceMap.get("root") != null && !(temp = resourceMap.get("root")).equals("/") && temp.length() != 0) {
            this.root = this.root.endsWith("/") ? this.root + resourceMap.get("root") : this.root + "/" + resourceMap.get("root");
        }
        if (this.charset == null) {
            this.charset = resourceMap.get("charset");
        }
        this.functionSuffix = resourceMap.get("functionSuffix");
        this.autoCheck = Boolean.parseBoolean(resourceMap.get("autoCheck"));
        this.functionRoot = resourceMap.get("functionRoot");
        URL url = this.classLoader.getResource("");
        this.gt = gt;
        if (url != null && url.getProtocol().equals("file") && (fnRoot = new File(url.getFile() + File.separator + this.root + File.separator + this.functionRoot)).exists()) {
            String ns = "";
            String path = "/".concat(this.functionRoot).concat("/");
            BeetlUtil.autoFileFunctionRegister(gt, fnRoot, ns, path, this.functionSuffix);
        }
    }

    @Override
    public boolean exist(String key) {
        URL url = this.classLoader.getResource(this.root + key);
        if (url == null) {
            url = this.classLoader.getClass().getResource(this.root + key);
        }
        return url != null;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String getResourceId(Resource resource, String id) {
        if (resource == null) {
            return id;
        }
        return BeetlUtil.getRelPath(resource.getId(), id);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getInfo() {
        return "ClassLoader:" + this.classLoader + " Path:" + this.root;
    }
}

