/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IGoto;
import org.beetl.core.statement.Statement;

public class WhileStatement
extends Statement
implements IGoto {
    public Expression exp;
    public Statement whileBody;
    public boolean hasGoto = false;

    public WhileStatement(Expression exp, Statement whileBody, GrammarToken token) {
        super(token);
        this.exp = exp;
        this.whileBody = whileBody;
        if (this.whileBody instanceof BlockStatement) {
            this.hasGoto = ((BlockStatement)whileBody).hasGoto;
        }
    }

    @Override
    public void execute(Context ctx) {
        block11: {
            Object result;
            if (this.hasGoto) {
                Object result2;
                while ((result2 = this.exp.evaluate(ctx)) instanceof Boolean) {
                    if (((Boolean)result2).booleanValue()) {
                        this.whileBody.execute(ctx);
                        switch (ctx.gotoFlag) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                ctx.gotoFlag = 0;
                                break;
                            }
                            case 3: {
                                return;
                            }
                            case 2: {
                                ctx.gotoFlag = 0;
                                return;
                            }
                        }
                        continue;
                    }
                    break block11;
                }
                BeetlException be = new BeetlException("BOOLEAN_EXPECTED_ERROR");
                be.pushToken(this.exp.token);
                throw be;
            }
            while ((result = this.exp.evaluate(ctx)) instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    this.whileBody.execute(ctx);
                    continue;
                }
                break block11;
            }
            BeetlException be = new BeetlException("BOOLEAN_EXPECTED_ERROR");
            be.pushToken(this.exp.token);
            throw be;
        }
    }

    @Override
    public boolean hasGoto() {
        return this.hasGoto;
    }

    @Override
    public void setGoto(boolean occour) {
        this.hasGoto = occour;
    }
}

