/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.beetl.core.AntlrProgramBuilder;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.TemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.parser.BeetlAntlrErrorStrategy;
import org.beetl.core.parser.BeetlLexer;
import org.beetl.core.parser.BeetlParser;
import org.beetl.core.parser.SyntaxErrorListener;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;

public class DefaultTemplateEngine
implements TemplateEngine {
    protected BeetlAntlrErrorStrategy antlrErrorStrategy = new BeetlAntlrErrorStrategy();
    protected SyntaxErrorListener syntaxError = new SyntaxErrorListener();

    @Override
    public Program createProgram(Resource resource, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        BeetlLexer lexer = null;
        try {
            lexer = new BeetlLexer((CharStream)CharStreams.fromReader((Reader)reader));
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.syntaxError);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BeetlParser parser = new BeetlParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)this.antlrErrorStrategy);
        BeetlParser.ProgContext tree = parser.prog();
        AntlrProgramBuilder pb = this.getAntlrBuilder(gt);
        ProgramMetaData data = pb.build((ParseTree)tree);
        Program program = new Program();
        program.metaData = data;
        program.res = resource;
        program.gt = gt;
        program.metaData.staticTextArray = new Object[textMap.size()];
        program.metaData.lineSeparator = cr;
        int i = 0;
        Configuration conf = gt.getConf();
        String charset = conf.getCharset();
        boolean byteOut = conf.isDirectByteOutput();
        for (Map.Entry<Integer, String> entry : textMap.entrySet()) {
            if (byteOut) {
                try {
                    program.metaData.staticTextArray[i++] = entry.getValue().getBytes(charset);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            program.metaData.staticTextArray[i++] = entry.getValue().toCharArray();
        }
        if (program.metaData.ajaxs != null) {
            for (AjaxStatement ajax : program.metaData.ajaxs.values()) {
                ProgramMetaData locaMetaData = ajax.getLocalProgramMetaData();
                locaMetaData.staticTextArray = program.metaData.staticTextArray;
                locaMetaData.lineSeparator = cr;
            }
        }
        return program;
    }

    protected void checkProgram(Program program) {
    }

    protected AntlrProgramBuilder getAntlrBuilder(GroupTemplate gt) {
        GrammarCreator gc = this.getGrammerCreator(gt);
        AntlrProgramBuilder pb = new AntlrProgramBuilder(gt, gc);
        return pb;
    }

    protected GrammarCreator getGrammerCreator(GroupTemplate gt) {
        GrammarCreator grammar = new GrammarCreator();
        if (gt.getConf().isStrict()) {
            grammar.disable("VarAssign");
            grammar.disable("Function");
            grammar.disable("IncDec");
            grammar.disable("VarRefAssignExp");
            grammar.disable("VarRefAssign");
            grammar.disable("ClassNativeCall");
            grammar.disable("InstanceNativeCall");
            grammar.disable("Arth");
            grammar.disable("Compare");
            grammar.disable("InstanceNativeCall");
        }
        return grammar;
    }
}

