/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.executor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultText;
import org.xml.sax.SAXException;
import winter.com.ideaaedi.classwinter.Reverses;
import winter.com.ideaaedi.classwinter.author.JustryDeng;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.exception.JVMException;
import winter.com.ideaaedi.classwinter.executor.DecryptExecutor;
import winter.com.ideaaedi.classwinter.util.Cache;
import winter.com.ideaaedi.classwinter.util.Constant;
import winter.com.ideaaedi.classwinter.util.EncryptClassArgs;
import winter.com.ideaaedi.classwinter.util.EncryptUtil;
import winter.com.ideaaedi.classwinter.util.ExceptionUtil;
import winter.com.ideaaedi.classwinter.util.FileOrderSupport;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.JVMUtil;
import winter.com.ideaaedi.classwinter.util.JarUtil;
import winter.com.ideaaedi.classwinter.util.JavaagentCmdArgs;
import winter.com.ideaaedi.classwinter.util.JavassistUtil;
import winter.com.ideaaedi.classwinter.util.Logger;
import winter.com.ideaaedi.classwinter.util.Pair;
import winter.com.ideaaedi.classwinter.util.PathUtil;
import winter.com.ideaaedi.classwinter.util.SimpleFileOrderSupport;
import winter.com.ideaaedi.classwinter.util.StrUtil;

public class EncryptExecutor {
    public boolean invokerIsPlugin = false;
    public final Set<String> CLASS_WINTER_FILES = new HashSet<String>();
    private final String originJarOrWar;
    private final boolean originIsJar;
    private final String finalName;
    private final String targetRootDir;
    private final String targetLibDir;
    private final String targetClassesDir;
    private final String password;
    private final Set<String> includeXmlPrefixSet;
    private final Set<String> excludeXmlPrefixSet;
    private final Set<String> toCleanXmlChildElementNameSet;
    private final LinkedHashSet<String> includePrefixSet;
    private final Set<String> includeLibSet;
    private final Set<String> protectedLibSet;
    private final Set<String> excludePrefixSet;
    private final String alreadyProtectedRootDir;
    private final Set<Pair<String, String>> alreadyProtectedLibSet;
    private final String supportFile;
    private final Set<String> jvmArgCheckSet;
    private final Map<String, String> libJarAndTmpDirMap;

    private EncryptExecutor(String originJarOrWar, boolean originIsJar, String finalName, String targetRootDir, String targetLibDir, String targetClassesDir, String password, Set<String> includeXmlPrefixSet, Set<String> excludeXmlPrefixSet, Set<String> toCleanXmlChildElementNameSet, LinkedHashSet<String> includePrefixSet, Set<String> excludePrefixSet, Set<String> includeLibSet, Set<String> protectedLibSet, String alreadyProtectedRootDir, Set<Pair<String, String>> alreadyProtectedLibSet, String supportFile, Set<String> jvmArgCheckSet) {
        this.CLASS_WINTER_FILES.add(Cache.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(JustryDeng.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(ClassWinterException.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(DecryptExecutor.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(Constant.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(EncryptUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(ExceptionUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(FileOrderSupport.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(IOUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(JarUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(JavaagentCmdArgs.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(Logger.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(Pair.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(PathUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(SimpleFileOrderSupport.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(StrUtil.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(EncryptClassArgs.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(Reverses.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(Reverses.class.getName().replace(".", "/").replace("Reverses", "Reverses$1") + ".class");
        this.CLASS_WINTER_FILES.add(JVMException.class.getName().replace(".", "/") + ".class");
        this.CLASS_WINTER_FILES.add(JVMUtil.class.getName().replace(".", "/") + ".class");
        this.libJarAndTmpDirMap = new HashMap<String, String>(8);
        this.originJarOrWar = originJarOrWar;
        this.originIsJar = originIsJar;
        this.finalName = finalName;
        this.targetRootDir = targetRootDir;
        this.targetLibDir = targetLibDir;
        this.targetClassesDir = targetClassesDir;
        this.password = password;
        this.includeXmlPrefixSet = includeXmlPrefixSet;
        this.excludeXmlPrefixSet = excludeXmlPrefixSet;
        this.toCleanXmlChildElementNameSet = toCleanXmlChildElementNameSet;
        this.includePrefixSet = includePrefixSet;
        this.excludePrefixSet = excludePrefixSet;
        this.includeLibSet = includeLibSet;
        this.protectedLibSet = protectedLibSet;
        this.alreadyProtectedRootDir = alreadyProtectedRootDir;
        this.alreadyProtectedLibSet = alreadyProtectedLibSet;
        this.supportFile = supportFile;
        this.jvmArgCheckSet = jvmArgCheckSet;
    }

    public String process() {
        Logger.debug(EncryptExecutor.class, "Generate seal -> " + Constant.SEAL);
        String lastStep = "step13";
        List<String> filePathList = JarUtil.unJarWar(this.originJarOrWar, this.targetRootDir);
        this.showProcess("step00", lastStep, "un-jar-war");
        File targetRootDirFile = new File(this.targetRootDir);
        if (this.includeXmlPrefixSet != null && this.includeXmlPrefixSet.size() > 0) {
            this.cleanXmlFiles(filePathList, targetRootDirFile);
        }
        this.showProcess("step01", lastStep, "clean-xml-files");
        this.unLibJar();
        this.showProcess("step02", lastStep, "un-lib-jar");
        List<File> allFiles = IOUtil.listSubFile(targetRootDirFile, 1);
        List<EncryptClassArgs> allNeedEncryptedClassInfoList = this.filterClasses(allFiles);
        this.showProcess("step03", lastStep, "filter-classes");
        List<String> allAlreadyEncryptedClassFileList = this.encryptClasses(allNeedEncryptedClassInfoList, new File(this.targetRootDir, "META-INF/winter/classes/"));
        this.generateChecklistFile(allAlreadyEncryptedClassFileList);
        this.showProcess("step04", lastStep, "encrypt-classes");
        this.generateSealFile();
        this.showProcess("step05", lastStep, "record-seal");
        this.settingJvmArgCheckItems();
        this.showProcess("step06", lastStep, "setting-jvm-arg-check-items");
        this.clearClassMethod(allNeedEncryptedClassInfoList);
        this.showProcess("step07", lastStep, "clear-class-method");
        this.clearWinterPluginInfo();
        this.showProcess("step08", lastStep, "clear-winter-plugin-info");
        this.addClassWinterAgent();
        this.showProcess("step09", lastStep, "add-class-winter-agent");
        this.collectAlreadyProtectedLibInfo();
        this.showProcess("step10", lastStep, "collect-already-protected-lib-info");
        this.doLibJar();
        this.showProcess("step11", lastStep, "do-lib-jar");
        String generatedJarWar = this.generateJarWarPath(this.originIsJar);
        JarUtil.doJarWar(this.targetRootDir, generatedJarWar, new SimpleFileOrderSupport(filePathList));
        this.showProcess("step12", lastStep, "generate-jar-war-path");
        IOUtil.delete(targetRootDirFile);
        this.showProcess(lastStep, lastStep, "delete-tmp-dir");
        return generatedJarWar;
    }

    private void cleanXmlFiles(List<String> filePathList, File targetRootDirFile) {
        HashSet<String> encryptNonClassFileSet = new HashSet<String>();
        String targetRootBaseDir = targetRootDirFile.getAbsolutePath();
        Set allNeedEncryptedNonClassFileSet = filePathList.stream().filter(x -> x.endsWith(".xml")).map(filepath -> {
            String zipEntryName = filepath.replace(targetRootBaseDir, "");
            zipEntryName = (zipEntryName = zipEntryName.replace('\\', '/')).startsWith("/") ? zipEntryName.substring(1) : zipEntryName;
            return zipEntryName;
        }).filter(zipEntryName -> {
            boolean shouldExclude;
            if (this.excludeXmlPrefixSet != null && (shouldExclude = this.excludeXmlPrefixSet.stream().anyMatch(s -> StrUtil.startsWithOrRegMatched(s, zipEntryName)))) {
                return false;
            }
            return this.includeXmlPrefixSet.stream().anyMatch(s -> StrUtil.startsWithOrRegMatched(s, zipEntryName));
        }).collect(Collectors.toSet());
        for (String zipEntryName2 : allNeedEncryptedNonClassFileSet) {
            byte[] bytes = IOUtil.readFileFromWorkbenchRoot(targetRootDirFile, zipEntryName2);
            Logger.debug(EncryptExecutor.class, "Encrypt non-class[" + zipEntryName2 + "] start.");
            byte[] encryptedBytes = EncryptUtil.encrypt(bytes, this.obtainPassword());
            IOUtil.toFile(encryptedBytes, new File(this.targetRootDir + File.separator + "META-INF/winter/non-classes/", zipEntryName2), true);
            Logger.debug(EncryptExecutor.class, "Encrypt non-class[" + zipEntryName2 + "] end.");
            encryptNonClassFileSet.add(zipEntryName2);
        }
        String nonClassChecklist = String.join((CharSequence)",", encryptNonClassFileSet);
        IOUtil.writeContentToFile(nonClassChecklist, new File(this.targetRootDir, "META-INF/winter/checklist.non-classes.winter"));
        for (String zipEntryName3 : encryptNonClassFileSet) {
            byte[] bytes = IOUtil.readFileFromWorkbenchRoot(targetRootDirFile, zipEntryName3);
            if (bytes == null) continue;
            String cleanedXml = this.clearXml(new String(bytes, StandardCharsets.UTF_8), "\n\t\t\t" + Constant.TIPS + "\n\t\t\t" + Constant.SEAL, this.toCleanXmlChildElementNameSet);
            IOUtil.writeContentToFile(cleanedXml, new File(this.targetRootDir, zipEntryName3));
        }
    }

    private void showProcess(String completedStep, String lastStep, String stepDesc) {
        if (this.invokerIsPlugin) {
            Logger.simpleInfo(completedStep + "/" + lastStep + "\t" + stepDesc + " completed.");
        } else {
            Logger.info(completedStep + "/" + lastStep + "\t" + stepDesc + " completed.");
        }
    }

    private void clearWinterPluginInfo() {
        if (!this.invokerIsPlugin) {
            return;
        }
        File metaInfMavenFile = new File(this.targetRootDir, "META-INF/maven");
        if (!metaInfMavenFile.exists()) {
            Logger.warn(metaInfMavenFile.getAbsolutePath() + "non-exist. skip clearWinterPluginInfo.");
            return;
        }
        IOUtil.listFileOnly(metaInfMavenFile, "pom.xml").stream().filter(x -> "pom.xml".equals(x.getName())).forEach(pomFile -> {
            Element pluginsElement;
            Document document;
            FileOutputStream fileOutputStream;
            block10: {
                Element buildElement;
                block9: {
                    Element projectElement;
                    block8: {
                        SAXReader saxReader = new SAXReader();
                        fileOutputStream = null;
                        document = saxReader.read((File)pomFile);
                        projectElement = document.getRootElement();
                        if (projectElement != null) break block8;
                        IOUtil.close(fileOutputStream);
                        return;
                    }
                    buildElement = projectElement.element("build");
                    if (buildElement != null) break block9;
                    IOUtil.close(fileOutputStream);
                    return;
                }
                pluginsElement = buildElement.element("plugins");
                if (pluginsElement != null) break block10;
                IOUtil.close(fileOutputStream);
                return;
            }
            try {
                Iterator iterator = pluginsElement.elementIterator();
                while (iterator.hasNext()) {
                    Element artifactIdElement;
                    Element pluginElement = (Element)iterator.next();
                    Element groupIdElement = pluginElement.element("groupId");
                    if (groupIdElement == null || groupIdElement.getStringValue() == null || !"com.idea-aedi".equals(groupIdElement.getStringValue().trim()) || (artifactIdElement = pluginElement.element("artifactId")) == null || artifactIdElement.getStringValue() == null || !"class-winter-maven-plugin".equals(artifactIdElement.getStringValue().trim())) continue;
                    pluginsElement.remove(pluginElement);
                }
                IOUtil.delete(pomFile);
                fileOutputStream = new FileOutputStream((File)pomFile);
                XMLWriter xmlwriter = new XMLWriter(fileOutputStream);
                xmlwriter.write(document);
                xmlwriter.flush();
            }
            catch (Exception e) {
                try {
                    throw new ClassWinterException("Delete class-winter-plugin info at pom.xml fail.", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileOutputStream);
                    throw throwable;
                }
            }
            IOUtil.close(fileOutputStream);
        });
    }

    private void collectAlreadyProtectedLibInfo() {
        if (this.alreadyProtectedLibSet == null || this.alreadyProtectedLibSet.size() == 0) {
            return;
        }
        HashMap<String, String> allChecklistInfoMap = new HashMap<String, String>(8);
        this.alreadyProtectedLibSet.forEach(pair -> {
            String[] libClassesArr;
            String libJarFilepath = (String)pair.getLeft();
            String password = (String)pair.getRight();
            File lib = new File(this.targetLibDir, libJarFilepath);
            if (!lib.exists()) {
                if (StrUtil.isBlank(this.alreadyProtectedRootDir)) {
                    Logger.warn("do locate lib. " + libJarFilepath + " non-exist. Under targetLibDir " + this.targetLibDir);
                } else {
                    lib = new File(this.alreadyProtectedRootDir, libJarFilepath);
                }
                if (lib.exists()) {
                    Logger.debug("do locate lib. " + libJarFilepath + " exist. Under alreadyProtectedRootDir " + this.alreadyProtectedRootDir);
                } else {
                    Logger.warn("do locate lib. " + libJarFilepath + " non-exist. Under alreadyProtectedRootDir " + this.alreadyProtectedRootDir);
                    return;
                }
            }
            String libName = lib.getName();
            String nonSuffixLibName = libName.substring(0, libName.length() - 4);
            String dirRelativePathForLib = "META-INF/winter/classes/" + nonSuffixLibName + "_jar" + "/";
            String dirAbsolutePathForLib = this.targetRootDir + File.separator + "META-INF/winter/classes/" + nonSuffixLibName + "_jar" + File.separator;
            byte[] checklistOfAllLibsByte = IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/classes/checklist-of-all-libs.winter");
            if (checklistOfAllLibsByte != null) {
                throw new ClassWinterException(libJarFilepath + "'s lib cannot be protected by class-winter.");
            }
            byte[] checklistByte = IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/checklist.classes.winter");
            if (checklistByte == null) {
                return;
            }
            String libChecklist = new String(checklistByte, StandardCharsets.UTF_8);
            IOUtil.writeContentToFile(libChecklist, new File(dirAbsolutePathForLib, "checklist.classes.winter"));
            allChecklistInfoMap.put(dirRelativePathForLib, libChecklist);
            for (String nonSuffixClassLongName : libClassesArr = libChecklist.split(",")) {
                byte[] libClazzByte = IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/classes/" + nonSuffixClassLongName);
                IOUtil.toFile(libClazzByte, new File(dirAbsolutePathForLib, nonSuffixClassLongName), true);
            }
            byte[] libSealByte = IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/seal.winter");
            if (libSealByte == null) {
                throw new ClassWinterException("Cannot find seal in lib [" + libJarFilepath + "]. This lib is not protected by class-winter.");
            }
            IOUtil.writeContentToFile(new String(libSealByte, StandardCharsets.UTF_8), new File(dirAbsolutePathForLib, "seal.winter"));
            boolean libUserIfInputPwd = Boolean.parseBoolean(new String(IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/userIfInputPwd.winter")));
            Logger.debug(EncryptExecutor.class, "libUserIfInputPwd info of lib [" + libJarFilepath + "] -> " + libUserIfInputPwd);
            if (libUserIfInputPwd && StrUtil.isBlank(password)) {
                throw new ClassWinterException("Password is required to decrypt lib [" + libJarFilepath + "]");
            }
            if (StrUtil.isBlank(password)) {
                byte[] libEncryptedPwdByte = IOUtil.readFileFromWorkbenchRoot(lib, "META-INF/winter/pwd.winter");
                if (libEncryptedPwdByte == null) {
                    throw new ClassWinterException("Cannot find pwd from lib [" + libJarFilepath + "]");
                }
                password = EncryptUtil.decrypt(new String(libEncryptedPwdByte, StandardCharsets.UTF_8), new String(libSealByte, StandardCharsets.UTF_8).toCharArray());
            }
            String encryptedPassword = EncryptUtil.encrypt(password, Constant.SEAL.toCharArray());
            IOUtil.writeContentToFile(encryptedPassword, new File(dirAbsolutePathForLib, "pwd.winter"));
            IOUtil.writeContentToFile("false", new File(dirAbsolutePathForLib, "userIfInputPwd.winter"));
        });
        HashMap tmpMap = new HashMap(128);
        StringBuilder checklistOfAllLibs = new StringBuilder(64);
        allChecklistInfoMap.forEach((k, v) -> {
            if (StrUtil.isBlank(v)) {
                return;
            }
            Arrays.stream(v.split(",")).filter(item -> !StrUtil.isBlank(item)).forEach(nonSuffixClassLongName -> {
                String libDir = (String)tmpMap.get(nonSuffixClassLongName);
                if (!StrUtil.isBlank(libDir)) {
                    throw new ClassWinterException(String.format("protected class[%s] conflict. one lib is [%s], another lib is [%s]", nonSuffixClassLongName, libDir, k));
                }
                tmpMap.put(nonSuffixClassLongName, k);
            });
            checklistOfAllLibs.append((String)k).append("=").append((String)v).append("\r\n");
        });
        if (checklistOfAllLibs.length() > 0) {
            IOUtil.writeContentToFile(checklistOfAllLibs.toString(), new File(this.targetRootDir, "META-INF/winter/classes/checklist-of-all-libs.winter"));
        }
    }

    private void unLibJar() {
        if (this.includeLibSet == null || this.includeLibSet.size() == 0) {
            return;
        }
        List<File> allJarFiles = IOUtil.listFileOnly(new File(this.targetRootDir), ".jar");
        List<File> neededEncryptedLibs = allJarFiles.stream().filter(jarFile -> !this.protectedLibSet.contains(jarFile.getName()) && this.includeLibSet.stream().anyMatch(s -> StrUtil.startsWithOrRegMatched(s, jarFile.getName()))).collect(Collectors.toList());
        neededEncryptedLibs.forEach(jar -> {
            String jarAbsolutePath = jar.getAbsolutePath();
            String temDir = jarAbsolutePath.substring(0, jarAbsolutePath.length() - ".jar".length()) + "__temp__";
            JarUtil.unJarWar(jarAbsolutePath, temDir);
            this.libJarAndTmpDirMap.put(jarAbsolutePath, temDir);
            IOUtil.delete(new File(jarAbsolutePath));
        });
    }

    private void doLibJar() {
        if (this.libJarAndTmpDirMap.isEmpty()) {
            return;
        }
        this.libJarAndTmpDirMap.forEach((jarFilePath, tmpDirPath) -> {
            JarUtil.doJarWar(tmpDirPath, jarFilePath);
            IOUtil.delete(new File((String)tmpDirPath));
        });
    }

    private void generateChecklistFile(List<String> classLongNameList) {
        if (classLongNameList == null || classLongNameList.isEmpty()) {
            return;
        }
        String content = String.join((CharSequence)",", classLongNameList);
        IOUtil.writeContentToFile(content, new File(this.targetRootDir, "META-INF/winter/checklist.classes.winter"));
    }

    private void generateSealFile() {
        IOUtil.writeContentToFile(Constant.SEAL, new File(this.targetRootDir, "META-INF/winter/seal.winter"));
    }

    private void settingJvmArgCheckItems() {
        String content;
        if (this.jvmArgCheckSet == null || this.jvmArgCheckSet.size() == 0) {
            content = "NON_CHECK_ITEM_AT_CLASS-WINTER";
        } else {
            StringBuilder sb = new StringBuilder(64);
            for (String checkItem : this.jvmArgCheckSet) {
                sb.append(checkItem).append(" ");
            }
            content = sb.toString();
        }
        Logger.debug(EncryptExecutor.class, "Setting jvmArgCheckItems -> " + content);
        byte[] encryptedBytes = EncryptUtil.encrypt(content.getBytes(StandardCharsets.UTF_8), this.obtainPassword());
        IOUtil.toFile(Base64.getEncoder().encode(encryptedBytes), new File(this.targetRootDir, "META-INF/winter/jscf.winter"), true);
    }

    private void addClassWinterAgent() {
        String classWinterProjectRootDir = PathUtil.getProjectRootDir(this.getClass());
        int classWinterProjectRootDirLength = classWinterProjectRootDir.length();
        if (classWinterProjectRootDir.endsWith("/classes/")) {
            List<File> allFileList = IOUtil.listSubFile(new File(classWinterProjectRootDir), 0);
            allFileList.forEach(file -> {
                String classLongNamePath = file.getAbsolutePath().substring(classWinterProjectRootDirLength);
                classLongNamePath = classLongNamePath.replace("\\", "/");
                File destFile = new File(this.targetRootDir, classLongNamePath);
                if (file.isFile()) {
                    if (this.CLASS_WINTER_FILES.stream().anyMatch(classLongNamePath::startsWith)) {
                        byte[] bytes = IOUtil.toBytes(file);
                        IOUtil.toFile(bytes, destFile, true);
                    }
                }
            });
        } else if (classWinterProjectRootDir.endsWith(".jar")) {
            JarUtil.unJarWar(classWinterProjectRootDir, this.targetRootDir, false, this.CLASS_WINTER_FILES);
        } else {
            throw new ClassWinterException("Execute method addClassWinterAgent() fail. Cannot parse classWinterProjectRootDir [" + classWinterProjectRootDir + "].");
        }
        File manifest = new File(this.targetRootDir, "META-INF/MANIFEST.MF");
        String preMain = "Premain-Class: " + Reverses.class.getName();
        String[] origin = new String[]{};
        if (manifest.exists()) {
            String originContent = IOUtil.readContentFromFile(manifest);
            if (!StrUtil.isBlank(originContent) && originContent.contains("Premain-Class: ")) {
                throw new ClassWinterException(this.originJarOrWar + " already exist Premain-Class at META-INF/MANIFEST.MF");
            }
            origin = originContent.split(System.lineSeparator());
        }
        String str = StrUtil.insertStrAfterLine(origin, preMain, "Main-Class:");
        str = str + System.lineSeparator();
        IOUtil.writeContentToFile(str, manifest);
    }

    private String generateJarWarPath(boolean originIsJar) {
        int endIndex = this.originJarOrWar.lastIndexOf("/");
        String jarRootParentDir = endIndex > 0 ? this.originJarOrWar.substring(0, endIndex + "/".length()) : "/";
        return jarRootParentDir + this.finalName + (originIsJar ? ".jar" : ".war");
    }

    private void clearClassMethod(List<EncryptClassArgs> allNeedEncryptedClassInfoList) {
        ClassPool pool = new ClassPool(true);
        try {
            JavassistUtil.loadJar(pool, this.targetRootDir);
            JavassistUtil.loadClass(pool, this.targetRootDir);
            if (!StrUtil.isBlank(this.supportFile)) {
                JavassistUtil.loadJar(pool, this.supportFile);
            }
        }
        catch (NotFoundException e) {
            throw new ClassWinterException(e);
        }
        allNeedEncryptedClassInfoList.forEach(encryptClassArgs -> {
            File classFile = encryptClassArgs.getEncryptClassFile();
            String className = JavassistUtil.resolveClassName(classFile.getAbsolutePath(), true);
            try {
                byte[] bts = JavassistUtil.clearMethodBody(pool, className, encryptClassArgs);
                IOUtil.toFile(bts, classFile, true);
            }
            catch (NotFoundException e) {
                Logger.warn(EncryptExecutor.class, "Ignore clear-method-body for className [" + className + "], Cannot find '" + e.getMessage() + "'");
            }
            catch (CannotCompileException e) {
                NotFoundException notFoundException = this.existNotFoundException(e, 5);
                if (notFoundException != null) {
                    Logger.warn(EncryptExecutor.class, "Ignore clear-method-body for className [" + className + "], Cannot find '" + notFoundException.getMessage() + "'");
                }
                throw new ClassWinterException(e);
            }
        });
        pool.clearImportedPackages();
    }

    private NotFoundException existNotFoundException(CannotCompileException e, int depth) {
        int i;
        if (e == null) {
            return null;
        }
        if (depth <= 0) {
            return null;
        }
        Throwable cause = e.getCause();
        NotFoundException notFoundException = null;
        for (i = 0; i < depth; ++i) {
            if (cause instanceof NotFoundException) {
                notFoundException = (NotFoundException)cause;
                break;
            }
            if (cause == null) break;
            cause = cause.getCause();
        }
        if (notFoundException != null) {
            return notFoundException;
        }
        cause = e;
        ++depth;
        for (i = 0; i < depth && cause != null && (notFoundException = EncryptExecutor.findFromMessage(cause.getMessage())) == null; cause = cause.getCause(), ++i) {
        }
        return notFoundException;
    }

    private static NotFoundException findFromMessage(String message) {
        if (message == null) {
            return null;
        }
        if (!message.contains("javassist.NotFoundException:")) {
            return null;
        }
        String targetClassName = message.substring(message.indexOf("javassist.NotFoundException:") + "javassist.NotFoundException:".length()).trim();
        return new NotFoundException(targetClassName);
    }

    private List<String> encryptClasses(List<EncryptClassArgs> encryptClassInfoList, File savaDir) {
        List<File> classFiles = encryptClassInfoList.stream().map(EncryptClassArgs::getEncryptClassFile).collect(Collectors.toList());
        JarUtil.guarantyDirExist(savaDir);
        classFiles.stream().map(File::getName).forEach(name -> {
            if (!name.endsWith(".class")) {
                throw new ClassWinterException("classFiles must all be class file. file [" + name + "] is illegal.");
            }
        });
        ArrayList<String> encryptClasses = new ArrayList<String>();
        classFiles.forEach(classFile -> {
            String className = JavassistUtil.resolveClassName(classFile.getAbsolutePath(), true);
            byte[] bytes = IOUtil.toBytes(classFile);
            Logger.debug(EncryptExecutor.class, "Encrypt class[" + className + "] start.");
            bytes = EncryptUtil.encrypt(bytes, this.obtainPassword());
            IOUtil.toFile(bytes, new File(savaDir, className), true);
            Logger.debug(EncryptExecutor.class, "Encrypt class[" + className + "] end.");
            encryptClasses.add(className);
        });
        return encryptClasses;
    }

    private char[] obtainPassword() {
        if (Cache.passwordCacheForEncrypt.containsKey(this.originJarOrWar)) {
            return Cache.passwordCacheForEncrypt.get(this.originJarOrWar);
        }
        boolean passwordIsBlank = StrUtil.isBlank(this.password);
        if (passwordIsBlank) {
            char[] generatedPwd = EncryptUtil.generateCharArr(new SecureRandom().nextInt(500) + 100);
            String encryptedGeneratedPwd = EncryptUtil.encrypt(new String(generatedPwd), Constant.SEAL.toCharArray());
            IOUtil.writeContentToFile(encryptedGeneratedPwd, new File(this.targetRootDir, "META-INF/winter/pwd.winter"));
            Cache.passwordCacheForEncrypt.put(this.originJarOrWar, generatedPwd);
        } else {
            Cache.passwordCacheForEncrypt.put(this.originJarOrWar, this.password.toCharArray());
        }
        IOUtil.writeContentToFile(passwordIsBlank ? "false" : "true", new File(this.targetRootDir, "META-INF/winter/userIfInputPwd.winter"));
        return Cache.passwordCacheForEncrypt.get(this.originJarOrWar);
    }

    private List<EncryptClassArgs> filterClasses(List<File> allFileList) {
        return allFileList.stream().filter(file -> file.getName().endsWith(".class")).map(file -> {
            String classLongName = JavassistUtil.resolveClassName(file.getAbsolutePath(), true);
            if (this.excludePrefixSet != null) {
                for (String excludePrefix : this.excludePrefixSet) {
                    if (!StrUtil.startsWithOrRegMatched(excludePrefix, classLongName)) continue;
                    return null;
                }
            }
            if (this.includePrefixSet != null) {
                for (String includePrefix : this.includePrefixSet) {
                    Pair<String, Map<String, String>> pair = this.extraPrefixAndParam(includePrefix);
                    String pureIncludePrefix = pair.getLeft();
                    Map<String, String> params = pair.getRight();
                    if (!StrUtil.startsWithOrRegMatched(pureIncludePrefix, classLongName)) continue;
                    return EncryptClassArgs.create(file, StrUtil.isTrueDefault(params.get("cca"), false), StrUtil.isTrueDefault(params.get("cma"), false), StrUtil.isTrueDefault(params.get("cfa"), false), params.get("caPrefix"), StrUtil.isTrueDefault(params.get("keepArgName"), true));
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Pair<String, Map<String, String>> extraPrefixAndParam(String includePrefix) {
        HashMap<String, String> param = new HashMap<String, String>(8);
        int index = includePrefix.indexOf("?");
        if (index < 0) {
            return Pair.of(includePrefix, param);
        }
        String pureIncludePrefix = includePrefix.substring(0, index);
        String paramStr = includePrefix.substring(index + 1);
        for (String keyValue : paramStr.split("&")) {
            int equalIndex = keyValue.indexOf("=");
            if (equalIndex < 0) continue;
            String key = keyValue.substring(0, equalIndex).trim();
            String value = keyValue.substring(equalIndex + 1).trim();
            if (StrUtil.isBlank(key) || StrUtil.isBlank(value)) continue;
            param.put(key, value);
        }
        return Pair.of(pureIncludePrefix, param);
    }

    private String clearXml(String xmlContent, String paddingComment, Set<String> toClearFirstNodeNameSet) {
        String string;
        Iterator iterator;
        Document document;
        ByteArrayOutputStream os;
        block10: {
            Element rootElement;
            block9: {
                if (toClearFirstNodeNameSet == null || toClearFirstNodeNameSet.size() == 0) {
                    return xmlContent;
                }
                if (xmlContent == null || xmlContent.trim().length() == 0) {
                    return xmlContent;
                }
                os = null;
                SAXReader reader = new SAXReader();
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                document = reader.read(new StringReader(xmlContent));
                rootElement = document.getRootElement();
                if (rootElement != null) break block9;
                String string2 = xmlContent;
                IOUtil.close(os);
                return string2;
            }
            iterator = rootElement.elementIterator();
            if (iterator != null) break block10;
            String string3 = null;
            IOUtil.close(os);
            return string3;
        }
        try {
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (element == null || !toClearFirstNodeNameSet.contains(element.getName())) continue;
                element.clearContent();
                element.add(new DefaultText("\n\t\t"));
                element.addComment(paddingComment + "\n\t\t");
                element.add(new DefaultText("\n\t"));
            }
            os = new ByteArrayOutputStream();
            XMLWriter xmlWriter = new XMLWriter(os);
            xmlWriter.write(document);
            xmlWriter.flush();
            xmlWriter.close();
            string = new String(os.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException | DocumentException | SAXException e) {
            try {
                throw new UndeclaredThrowableException(e, String.format("clear xmlContent exception. \nxmlContent -> %s, \npaddingComment -> %s, \ntoClearFirstNodeNameSet -> %s", xmlContent, paddingComment, toClearFirstNodeNameSet));
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
        return string;
    }

    public String toString() {
        return "EncryptExecutor{originJarOrWar='" + this.originJarOrWar + '\'' + ", originIsJar=" + this.originIsJar + ", finalName='" + this.finalName + '\'' + ", targetRootDir='" + this.targetRootDir + '\'' + ", targetLibDir='" + this.targetLibDir + '\'' + ", targetClassesDir='" + this.targetClassesDir + '\'' + ", password='" + (StrUtil.isBlank(this.password) ? null : "******") + '\'' + ", supportFile='" + this.supportFile + '\'' + ", jvmArgCheckSet='" + this.jvmArgCheckSet + '\'' + ", includePrefixSet=" + this.includePrefixSet + ", excludePrefixSet=" + this.excludePrefixSet + ", includeXmlPrefixSet=" + this.includeXmlPrefixSet + ", excludeXmlPrefixSet=" + this.excludeXmlPrefixSet + ", toCleanChildElementNameSet=" + this.toCleanXmlChildElementNameSet + ", includeLibSet=" + this.includeLibSet + ", protectedLibSet=" + this.protectedLibSet + ", alreadyProtectedLibSet=" + this.alreadyProtectedLibSet + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String originJarOrWar;
        private String finalName;
        private String password;
        private String includePrefix;
        private String excludePrefix;
        private String includeXmlPrefix;
        private String excludeXmlPrefix;
        private String toCleanXmlChildElementName;
        private String includeLibs;
        private String alreadyProtectedRootDir;
        private String alreadyProtectedLibs;
        private String supportFile;
        private String jvmArgCheck;
        private Boolean debug = false;
        private String tips;

        public Builder originJarOrWar(String originJarOrWar) {
            this.originJarOrWar = originJarOrWar;
            return this;
        }

        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder includePrefix(String includePrefix) {
            this.includePrefix = includePrefix;
            return this;
        }

        public Builder excludePrefix(String excludePrefix) {
            this.excludePrefix = excludePrefix;
            return this;
        }

        public Builder includeXmlPrefix(String includeXmlPrefix) {
            this.includeXmlPrefix = includeXmlPrefix;
            return this;
        }

        public Builder excludeXmlPrefix(String excludeXmlPrefix) {
            this.excludeXmlPrefix = excludeXmlPrefix;
            return this;
        }

        public Builder toCleanXmlChildElementName(String toCleanXmlChildElementName) {
            this.toCleanXmlChildElementName = toCleanXmlChildElementName;
            return this;
        }

        public Builder includeLibs(String includeLibs) {
            this.includeLibs = includeLibs;
            return this;
        }

        public Builder alreadyProtectedLibs(String alreadyProtectedLibs) {
            this.alreadyProtectedLibs = alreadyProtectedLibs;
            return this;
        }

        public Builder alreadyProtectedRootDir(String alreadyProtectedRootDir) {
            this.alreadyProtectedRootDir = alreadyProtectedRootDir;
            return this;
        }

        public Builder supportFile(String supportFile) {
            this.supportFile = supportFile;
            return this;
        }

        public Builder jvmArgCheck(String jvmArgCheck) {
            this.jvmArgCheck = jvmArgCheck;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder tips(String tips) {
            this.tips = tips;
            return this;
        }

        public EncryptExecutor build() {
            File originFile;
            Logger.ENABLE_DEBUG.set(this.debug != null && this.debug != false);
            if (!StrUtil.isEmpty(this.tips)) {
                Constant.TIPS.setLength(0);
                Constant.TIPS.append(this.tips);
            }
            if (StrUtil.isEmpty(this.originJarOrWar)) {
                throw new ClassWinterException("originJarOrWar cannot be empty.");
            }
            if (!this.originJarOrWar.endsWith(".jar") && !this.originJarOrWar.endsWith(".war")) {
                throw new ClassWinterException("originJarOrWar must be Jar or War file.");
            }
            if (StrUtil.isEmpty(this.includePrefix)) {
                throw new ClassWinterException("includePrefix cannot be empty.");
            }
            if (!StrUtil.isBlank(this.supportFile)) {
                File tmpFile = new File(this.supportFile);
                if (!tmpFile.exists()) {
                    throw new ClassWinterException("supportFile [" + this.supportFile + "] non-exist.");
                }
                if (tmpFile.isFile() && !this.supportFile.endsWith(".jar")) {
                    throw new ClassWinterException("supportFile must be dir or a jar file.");
                }
            }
            if (!StrUtil.isBlank(this.password)) {
                this.password = this.password.trim();
                if (this.password.contains(" ") || this.password.contains(",")) {
                    throw new ClassWinterException("password cannot contain whitespace or comma.");
                }
            }
            if (!(originFile = new File(this.originJarOrWar)).exists()) {
                throw new ClassWinterException("cannot find file [" + this.originJarOrWar + "].");
            }
            this.originJarOrWar = originFile.getAbsolutePath().replace(File.separator, "/");
            boolean originIsJar = JarUtil.isJarOrWar(this.originJarOrWar);
            if (StrUtil.isEmpty(this.finalName)) {
                String originFileName = originFile.getName();
                int idx = originFileName.lastIndexOf(".");
                this.finalName(originFileName.substring(0, idx) + "-encrypted");
            }
            String targetRootDir = this.originJarOrWar.substring(0, this.originJarOrWar.length() - 4) + "__temp__";
            String targetLibDir = String.join((CharSequence)File.separator, targetRootDir, originIsJar ? "BOOT-INF" : "WEB-INF", "lib");
            String targetClassesDir = String.join((CharSequence)File.separator, targetRootDir, originIsJar ? "BOOT-INF" : "WEB-INF", "classes");
            Set<String> includePrefixSet = StrUtil.strToSet(this.includePrefix);
            LinkedHashSet<String> includePrefixSortSet = Builder.sortByPurePrefixLenthDesc(includePrefixSet);
            Set<String> excludePrefixSet = StrUtil.strToSet(this.excludePrefix);
            Set<String> includeLibSet = StrUtil.strToSet(this.includeLibs);
            Set<Pair<String, String>> alreadyProtectedLibSet = this.parseAlreadyProtectedLibs();
            HashSet matchAlreadyProtectedLibSet = new HashSet();
            alreadyProtectedLibSet.stream().map(Pair::getLeft).forEach(lib -> {
                if (includeLibSet.stream().anyMatch(s -> StrUtil.startsWithOrRegMatched(s, lib))) {
                    Logger.warn(EncryptExecutor.class, "Ignore includeLibs item [" + lib + "], because this item already be protected by class-winter.");
                    matchAlreadyProtectedLibSet.add(lib);
                }
            });
            for (String jarFile : includeLibSet) {
                if (jarFile.endsWith(".jar")) continue;
                throw new ClassWinterException("includeLibs format must be shaped like xxx1.jar[,xxx2.jar,xxx3.jar]");
            }
            Set<String> includeXmlPrefixSet = StrUtil.strToSet(this.includeXmlPrefix);
            Set<String> jvmArgCheckSet = StrUtil.strToSet(this.jvmArgCheck);
            Set<String> excludeXmlPrefixSet = StrUtil.strToSet(this.excludeXmlPrefix);
            this.toCleanXmlChildElementName = StrUtil.isBlank(this.toCleanXmlChildElementName) ? "resultMap,sql,insert,update,delete,select" : this.toCleanXmlChildElementName;
            Set<String> toCleanXmlChildElementNameSet = StrUtil.strToSet(this.toCleanXmlChildElementName);
            return new EncryptExecutor(this.originJarOrWar, originIsJar, this.finalName, targetRootDir, targetLibDir, targetClassesDir, this.password, includeXmlPrefixSet, excludeXmlPrefixSet, toCleanXmlChildElementNameSet, includePrefixSortSet, excludePrefixSet, includeLibSet, matchAlreadyProtectedLibSet, this.alreadyProtectedRootDir, alreadyProtectedLibSet, this.supportFile, jvmArgCheckSet);
        }

        private static LinkedHashSet<String> sortByPurePrefixLenthDesc(Set<String> includePrefixSet) {
            ArrayList<String> includePrefixSortList = new ArrayList<String>(includePrefixSet);
            includePrefixSortList.sort(Comparator.comparingInt(x -> {
                int idx = x.indexOf("?");
                if (idx < 0) {
                    return x.length();
                }
                return x.substring(0, idx).length();
            }));
            Collections.reverse(includePrefixSortList);
            return new LinkedHashSet<String>(includePrefixSortList);
        }

        private Set<Pair<String, String>> parseAlreadyProtectedLibs() {
            HashSet<Pair<String, String>> alreadyProtectedLibSet = new HashSet<Pair<String, String>>();
            Set<String> alreadyProtectedLibInfoSet = StrUtil.strToSet(this.alreadyProtectedLibs);
            for (String info : alreadyProtectedLibInfoSet) {
                int idx = info.indexOf(":");
                if (idx >= 0) {
                    alreadyProtectedLibSet.add(Pair.of(info.substring(0, idx), info.substring(idx + 1)));
                    continue;
                }
                alreadyProtectedLibSet.add(Pair.of(info, null));
            }
            return alreadyProtectedLibSet;
        }
    }
}

