/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.JarUtil;
import winter.com.ideaaedi.classwinter.util.Logger;

public final class IOUtil {
    public static void toFile(byte[] srcFileBytes, File destFile, boolean createIfNecessary) {
        FileOutputStream os = null;
        try {
            if (destFile.isDirectory()) {
                throw new ClassWinterException("destFile [" + destFile.getAbsolutePath() + "] must be file rather than dir.");
            }
            if (createIfNecessary && !destFile.exists()) {
                boolean mkdirs;
                File parentFile = destFile.getParentFile();
                if (!(parentFile.exists() && parentFile.isDirectory() || (mkdirs = parentFile.mkdirs()))) {
                    Arrays.stream((Object[])Objects.requireNonNull(parentFile.getParentFile().listFiles())).filter(file -> file.getName().equalsIgnoreCase(parentFile.getName())).findFirst().ifPresent(conflictFile -> {
                        String renameFilePath = conflictFile.getAbsolutePath() + "_" + System.currentTimeMillis();
                        boolean renameResult = conflictFile.renameTo(new File(renameFilePath));
                        Logger.warn(IOUtil.class, "rename file [" + conflictFile.getAbsolutePath() + "] to [" + renameFilePath + "] " + (renameResult ? "success" : "fail") + ".");
                    });
                    mkdirs = parentFile.mkdirs();
                    if (!mkdirs) {
                        Logger.warn(IOUtil.class, "create dir [" + parentFile.getAbsolutePath() + "] fail.");
                    }
                }
                destFile.createNewFile();
            } else if (!destFile.exists()) {
                throw new IllegalArgumentException("destFile [" + destFile.getAbsolutePath() + "] non exist.");
            }
            os = new FileOutputStream(destFile);
            ((OutputStream)os).write(srcFileBytes, 0, srcFileBytes.length);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(" toFile [" + destFile.getAbsolutePath() + "] occur exception.", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    public static byte[] toBytes(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return IOUtil.toBytes(inputStream);
        }
        catch (IOException e) {
            throw new ClassWinterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(InputStream inputStream) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[4096];
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtil.close(output, inputStream);
            throw throwable;
        }
        IOUtil.close(output, inputStream);
        return byArray;
    }

    public static List<File> listFileOnly(File dirOrFile, String ... suffix) {
        if (!dirOrFile.exists()) {
            throw new IllegalArgumentException("listFileOnly [" + dirOrFile.getAbsolutePath() + "] non exist.");
        }
        return IOUtil.listFile(dirOrFile, 1).stream().filter(file -> {
            if (suffix == null) {
                return true;
            }
            String fileName = file.getName();
            return Arrays.stream(suffix).anyMatch(fileName::endsWith);
        }).collect(Collectors.toList());
    }

    public static List<File> listSubFile(File dirOrFile, int mode) {
        List<File> fileContainer = IOUtil.listFile(dirOrFile, mode);
        String absolutePath = dirOrFile.getAbsolutePath();
        Objects.requireNonNull(absolutePath, "absolutePath cannot be null.");
        fileContainer = fileContainer.stream().filter(file -> !absolutePath.equals(file.getAbsolutePath())).collect(Collectors.toList());
        return fileContainer;
    }

    public static List<File> listFile(File dirOrFile, int mode) {
        ArrayList<File> fileContainer = new ArrayList<File>(16);
        IOUtil.listFile(dirOrFile, fileContainer, mode);
        return fileContainer;
    }

    public static void listFile(File dirOrFile, List<File> fileContainer, int mode) {
        if (!dirOrFile.exists()) {
            return;
        }
        int fileAndDirMode = 0;
        int onlyFileMode = 1;
        int onlyDirMode = 2;
        if (mode != fileAndDirMode && mode != onlyFileMode && mode != onlyDirMode) {
            throw new IllegalArgumentException("mode [" + mode + "] is non-supported. 0,1,2is only support.");
        }
        if (dirOrFile.isDirectory()) {
            File[] files = dirOrFile.listFiles();
            if (files != null) {
                for (File f : files) {
                    IOUtil.listFile(f, fileContainer, mode);
                }
            }
            if (mode == fileAndDirMode || mode == onlyDirMode) {
                fileContainer.add(dirOrFile);
            }
        } else if (mode == fileAndDirMode || mode == onlyFileMode) {
            fileContainer.add(dirOrFile);
        }
    }

    public static void delete(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            boolean success = dirOrFile.delete();
            if (!success) {
                Logger.debug(IOUtil.class, "delete file [" + dirOrFile.getAbsolutePath() + "] fail.");
            }
        } else {
            File[] files = dirOrFile.listFiles();
            if (files != null) {
                for (File f : files) {
                    IOUtil.delete(f);
                }
            }
        }
        dirOrFile.delete();
    }

    public static int copy(InputStream src, OutputStream dest) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int count = 0;
        while (-1 != (n = src.read(buffer))) {
            dest.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static long computeCrc32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return crc32.getValue();
    }

    public static void writeContentToFile(String content, File file) {
        BufferedWriter out = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new BufferedWriter(new FileWriter(file));
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close(out);
    }

    public static String readContentFromFile(File file) {
        StringBuilder content = new StringBuilder();
        FileInputStream fileInputStream = null;
        InputStreamReader read = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileInputStream = new FileInputStream(file);
            read = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(read);
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(bufferedReader, read, fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close(bufferedReader, read, fileInputStream);
        return content.toString();
    }

    public static void close(Closeable ... ioArr) {
        if (ioArr == null) {
            return;
        }
        for (Closeable io : ioArr) {
            if (io == null) continue;
            try {
                io.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] mergeByte(byte[] ... byteArr) {
        int length = 0;
        for (byte[] b : byteArr) {
            length += b.length;
        }
        byte[] bt = new byte[length];
        int lastLength = 0;
        for (byte[] b : byteArr) {
            System.arraycopy(b, 0, bt, lastLength, b.length);
            lastLength += b.length;
        }
        return bt;
    }

    public static byte[] readFileFromWorkbenchRoot(File workbenchRoot, String relativeFilePath) {
        byte[] bytes;
        if (workbenchRoot.isFile()) {
            String workDirName = workbenchRoot.getName();
            if (!workDirName.endsWith(".jar") && !workDirName.endsWith(".war")) {
                throw new ClassWinterException("workDirName [" + workDirName + "] is not support.");
            }
            bytes = JarUtil.getFileFromZip(workbenchRoot, relativeFilePath);
        } else {
            File file = new File(workbenchRoot, relativeFilePath);
            if (!file.exists()) {
                return null;
            }
            bytes = IOUtil.toBytes(file);
        }
        return bytes;
    }

    public static boolean startWithCAFEBABE(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return false;
        }
        return Integer.toHexString(bytes[0]).toUpperCase(Locale.ENGLISH).endsWith("CA") && Integer.toHexString(bytes[0]).toUpperCase(Locale.ENGLISH).endsWith("FE") && Integer.toHexString(bytes[0]).toUpperCase(Locale.ENGLISH).endsWith("BA") && Integer.toHexString(bytes[0]).toUpperCase(Locale.ENGLISH).endsWith("BE");
    }
}

