/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class CheckBoxFormFieldBuilder
extends TerminalFormFieldBuilder<CheckBoxFormFieldBuilder> {
    private CheckBoxType checkType = CheckBoxType.CROSS;

    public CheckBoxFormFieldBuilder(PdfDocument document, String formFieldName) {
        super(document, formFieldName);
    }

    public CheckBoxType getCheckType() {
        return this.checkType;
    }

    public CheckBoxFormFieldBuilder setCheckType(CheckBoxType checkType) {
        this.checkType = checkType;
        return this;
    }

    public PdfButtonFormField createCheckBox() {
        PdfButtonFormField check;
        if (this.getWidgetRectangle() == null) {
            check = new PdfButtonFormField(this.getDocument());
        } else {
            PdfWidgetAnnotation annotation = new PdfWidgetAnnotation(this.getWidgetRectangle());
            annotation.setAppearanceState(new PdfName("Off"));
            if (this.getConformanceLevel() != null) {
                annotation.setFlag(4);
            }
            check = new PdfButtonFormField(annotation, this.getDocument());
        }
        check.pdfAConformanceLevel = this.getConformanceLevel();
        check.setCheckType(this.checkType);
        check.setFieldName(this.getFormFieldName());
        check.put(PdfName.V, (PdfObject)new PdfName("Off"));
        if (this.getWidgetRectangle() != null) {
            check.getFirstFormAnnotation().drawCheckBoxAndSaveAppearance("Yes");
            this.setPageToField(check);
        }
        return check;
    }

    @Override
    protected CheckBoxFormFieldBuilder getThis() {
        return this;
    }
}

