/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.renderer.AbstractSelectFieldRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.List;

public class SelectFieldListBoxRenderer
extends AbstractSelectFieldRenderer {
    public SelectFieldListBoxRenderer(AbstractSelectField modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new SelectFieldListBoxRenderer((AbstractSelectField)this.modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        IRenderer firstSelectedOption;
        List<IRenderer> selectedOptions;
        IRenderer optionsContainer;
        LayoutResult layoutResult = super.layout(layoutContext);
        IRenderer iRenderer = optionsContainer = this.childRenderers.size() == 1 ? (IRenderer)this.childRenderers.get(0) : null;
        if (!this.isFlatten() || layoutResult.getStatus() != 1 || optionsContainer == null || optionsContainer.getOccupiedArea() == null) {
            return layoutResult;
        }
        if (SelectFieldListBoxRenderer.isOverflowProperty((OverflowPropertyValue)OverflowPropertyValue.HIDDEN, (IRenderer)this, (int)104) && !(selectedOptions = this.getSelectedOptions((IRenderer)this)).isEmpty() && (firstSelectedOption = selectedOptions.get(0)).getOccupiedArea() != null) {
            Rectangle borderAreaBBox = this.getBorderAreaBBox();
            Rectangle optionBBox = firstSelectedOption.getOccupiedArea().getBBox().clone();
            if (firstSelectedOption instanceof AbstractRenderer) {
                ((AbstractRenderer)firstSelectedOption).applyMargins(optionBBox, false);
            }
            if (optionBBox.getHeight() < borderAreaBBox.getHeight()) {
                float borderAreaBBoxBottom;
                float selectedBottom = optionBBox.getBottom();
                if (selectedBottom < (borderAreaBBoxBottom = borderAreaBBox.getBottom())) {
                    optionsContainer.move(0.0f, borderAreaBBoxBottom - selectedBottom);
                }
            } else {
                optionsContainer.move(0.0f, borderAreaBBox.getTop() - optionBBox.getTop());
            }
        }
        return layoutResult;
    }

    protected boolean allowLastYLineRecursiveExtraction() {
        return false;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        IRenderer rendererSubTree;
        AccessibilityProperties properties;
        AbstractSelectField selectField = (AbstractSelectField)this.modelElement;
        List<IBlockElement> options = selectField.getOptions();
        Div optionsContainer = new Div();
        for (IBlockElement option : options) {
            optionsContainer.add(option);
        }
        String lang = this.getLang();
        if (lang != null && (properties = optionsContainer.getAccessibilityProperties()).getLanguage() == null) {
            properties.setLanguage(lang);
        }
        if (optionsContainer.getChildren().isEmpty()) {
            Paragraph pStub = (Paragraph)new Paragraph("\u00a0").setMargin(0.0f);
            pStub.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
            pStub.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
            pStub.setProperty(0x200009, (Object)false);
            optionsContainer.add((IBlockElement)pStub);
            rendererSubTree = optionsContainer.createRendererSubTree();
        } else {
            rendererSubTree = optionsContainer.createRendererSubTree();
            List<IRenderer> selectedOptions = this.getSelectedOptions(rendererSubTree);
            for (IRenderer selectedOption : selectedOptions) {
                this.applySelectedStyle(selectedOption);
            }
        }
        return rendererSubTree;
    }

    @Override
    protected float getFinalSelectFieldHeight(float availableHeight, float actualHeight, boolean isClippedHeight) {
        float calculatedHeight;
        Float height = this.retrieveHeight();
        if (height == null) {
            Float minHeight;
            calculatedHeight = this.getCalculatedHeight((IRenderer)this);
            Float maxHeight = this.retrieveMaxHeight();
            if (maxHeight != null && maxHeight.floatValue() < calculatedHeight) {
                calculatedHeight = maxHeight.floatValue();
            }
            if ((minHeight = this.retrieveMinHeight()) != null && minHeight.floatValue() > calculatedHeight) {
                calculatedHeight = minHeight.floatValue();
            }
        } else {
            calculatedHeight = actualHeight;
        }
        return super.getFinalSelectFieldHeight(availableHeight, calculatedHeight, isClippedHeight);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
    }

    private float getCalculatedHeight(IRenderer flatRenderer) {
        Integer sizeProp = (Integer)this.getProperty(0x200002);
        int size = sizeProp == null || sizeProp <= 0 ? 4 : sizeProp;
        float maxOptionActualHeight = this.getMaxOptionActualHeight(flatRenderer);
        if (maxOptionActualHeight == Float.MIN_VALUE) {
            UnitValue fontSize = (UnitValue)flatRenderer.getProperty(24);
            maxOptionActualHeight = fontSize != null && fontSize.isPointValue() ? fontSize.getValue() * 1.2f : 0.0f;
        }
        return (float)size * maxOptionActualHeight;
    }

    private float getMaxOptionActualHeight(IRenderer flatRenderer) {
        float maxActualHeight = Float.MIN_VALUE;
        for (IRenderer child : flatRenderer.getChildRenderers()) {
            if (SelectFieldListBoxRenderer.isOptionRenderer(child)) {
                float childHeight;
                if (child instanceof AbstractRenderer) {
                    AbstractRenderer abstractChild = (AbstractRenderer)child;
                    childHeight = abstractChild.applyMargins(abstractChild.getOccupiedAreaBBox(), false).getHeight();
                } else {
                    childHeight = child.getOccupiedArea().getBBox().getHeight();
                }
                if (!(childHeight > maxActualHeight)) continue;
                maxActualHeight = childHeight;
                continue;
            }
            float maxNestedHeight = this.getMaxOptionActualHeight(child);
            if (!(maxNestedHeight > maxActualHeight)) continue;
            maxActualHeight = maxNestedHeight;
        }
        return maxActualHeight;
    }

    private List<IRenderer> getSelectedOptions(IRenderer rendererSubTree) {
        ArrayList<IRenderer> selectedOptions = new ArrayList<IRenderer>();
        List<IRenderer> optionsWhichMarkedSelected = this.getOptionsMarkedSelected(rendererSubTree);
        if (!optionsWhichMarkedSelected.isEmpty()) {
            if (this.isMultiple()) {
                selectedOptions.addAll(optionsWhichMarkedSelected);
            } else {
                selectedOptions.add(optionsWhichMarkedSelected.get(optionsWhichMarkedSelected.size() - 1));
            }
        }
        return selectedOptions;
    }

    private boolean isMultiple() {
        Boolean propertyAsBoolean = this.getPropertyAsBoolean(0x200008);
        return propertyAsBoolean != null && propertyAsBoolean != false;
    }

    private void applySelectedStyle(IRenderer selectedOption) {
        selectedOption.setProperty(6, (Object)new Background((Color)new DeviceRgb(0, 120, 215)));
        this.setFontColorRecursively(selectedOption);
    }

    private void setFontColorRecursively(IRenderer selectedOption) {
        selectedOption.setProperty(21, (Object)new TransparentColor(ColorConstants.WHITE));
        for (IRenderer renderer : selectedOption.getChildRenderers()) {
            this.setFontColorRecursively(renderer);
        }
    }
}

