/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.impl.layout.PageTargetCountElement;
import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTargetCountRenderer
extends TextRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageTargetCountRenderer.class);
    private static final String UNDEFINED_VALUE = "0";
    private final String target;
    private final CounterDigitsGlyphStyle digitsGlyphStyle;

    PageTargetCountRenderer(PageTargetCountElement textElement) {
        super((Text)textElement);
        this.digitsGlyphStyle = textElement.getDigitsGlyphStyle();
        this.target = textElement.getTarget();
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        String previousText = this.getText().toString();
        Integer page = TargetCounterHandler.getPageByID((IRenderer)this, (String)this.target);
        if (page == null) {
            this.setText(UNDEFINED_VALUE);
        } else {
            this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, page));
        }
        LayoutResult result = super.layout(layoutContext);
        this.setText(previousText);
        return result;
    }

    public void draw(DrawContext drawContext) {
        if (!TargetCounterHandler.isValueDefinedForThisId((IRenderer)this, (String)this.target)) {
            LOGGER.warn(MessageFormatUtil.format((String)"Cannot resolve target-counter value with given target \"{0}\"", (Object[])new Object[]{this.target}));
        }
        super.draw(drawContext);
    }

    public IRenderer getNextRenderer() {
        return this;
    }

    protected boolean resolveFonts(List<IRenderer> addTo) {
        ArrayList dummyList = new ArrayList();
        super.resolveFonts(dummyList);
        this.setProperty(20, ((IRenderer)dummyList.get(0)).getProperty(20));
        addTo.add((IRenderer)this);
        return true;
    }
}

