/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.html2pdf.attach.impl.layout.RunningElement;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.util.WhiteSpaceUtil;
import java.util.ArrayList;
import java.util.List;

public final class TrimUtil {
    private TrimUtil() {
    }

    static List<IElement> trimLeafElementsAndSanitize(List<IElement> leafElements) {
        ArrayList<IElement> waitingLeaves = new ArrayList<IElement>(leafElements);
        TrimUtil.trimSubList(waitingLeaves, 0, waitingLeaves.size(), false);
        TrimUtil.trimSubList(waitingLeaves, 0, waitingLeaves.size(), true);
        for (int pos = 0; pos < waitingLeaves.size() - 1; ++pos) {
            if (!(waitingLeaves.get(pos) instanceof Text)) continue;
            Text first = (Text)waitingLeaves.get(pos);
            if (TrimUtil.isElementFloating((IElement)first)) {
                TrimUtil.trimTextElement(first, false);
                TrimUtil.trimTextElement(first, true);
                continue;
            }
            int firstEnd = TrimUtil.getIndexAfterLastNonSpace(first);
            if (firstEnd >= first.getText().length()) continue;
            TrimUtil.trimSubList(waitingLeaves, pos + 1, waitingLeaves.size(), false);
            first.setText(first.getText().substring(0, firstEnd + 1));
        }
        return waitingLeaves;
    }

    static boolean isNonLineBreakSpace(char ch) {
        return WhiteSpaceUtil.isNonEmSpace((char)ch) && ch != '\n';
    }

    private static void trimSubList(ArrayList<IElement> list, int begin, int end, boolean last) {
        while (end > begin) {
            int pos = last ? end - 1 : begin;
            IElement leaf = list.get(pos);
            if (TrimUtil.isElementFloating(leaf) || leaf instanceof RunningElement) {
                if (last) {
                    --end;
                    continue;
                }
                ++begin;
                continue;
            }
            if (!(leaf instanceof Text)) break;
            Text text = (Text)leaf;
            TrimUtil.trimTextElement(text, last);
            if (text.getText().length() != 0) break;
            if (TrimUtil.hasZeroWidth((IElement)text)) {
                list.remove(pos);
            }
            --end;
        }
    }

    private static void trimTextElement(Text text, boolean last) {
        int begin = last ? 0 : TrimUtil.getIndexOfFirstNonSpace(text);
        int end = last ? TrimUtil.getIndexAfterLastNonSpace(text) : text.getText().length();
        text.setText(text.getText().substring(begin, end));
    }

    private static int getIndexOfFirstNonSpace(Text text) {
        int pos;
        for (pos = 0; pos < text.getText().length() && TrimUtil.isNonLineBreakSpace(text.getText().charAt(pos)); ++pos) {
        }
        return pos;
    }

    private static int getIndexAfterLastNonSpace(Text text) {
        int pos;
        for (pos = text.getText().length(); pos > 0 && TrimUtil.isNonLineBreakSpace(text.getText().charAt(pos - 1)); --pos) {
        }
        return pos;
    }

    private static boolean isElementFloating(IElement leafElement) {
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)leafElement.getProperty(99);
        Integer position = (Integer)leafElement.getProperty(52);
        return (position == null || position != 3) && floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE);
    }

    private static boolean hasZeroWidth(IElement leafElement) {
        return !(null != leafElement.getProperty(12) && 0.0f != ((Border)leafElement.getProperty(12)).getWidth() || null != leafElement.getProperty(11) && 0.0f != ((Border)leafElement.getProperty(11)).getWidth() || null != leafElement.getProperty(49) && 0.0f != ((UnitValue)leafElement.getProperty(49)).getValue() || null != leafElement.getProperty(48) && 0.0f != ((UnitValue)leafElement.getProperty(48)).getValue() || null != leafElement.getProperty(45) && 0.0f != ((UnitValue)leafElement.getProperty(45)).getValue() || null != leafElement.getProperty(44) && 0.0f != ((UnitValue)leafElement.getProperty(44)).getValue());
    }
}

