/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.Attacher;
import com.itextpdf.html2pdf.attach.impl.OutlineHandler;
import com.itextpdf.html2pdf.exceptions.Html2PdfException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.pdfa.PdfADocument;
import com.itextpdf.pdfua.PdfUAConfig;
import com.itextpdf.pdfua.PdfUADocument;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.JsoupHtmlParser;
import com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class HtmlConverter {
    private HtmlConverter() {
    }

    public static void convertToPdf(String html, OutputStream pdfStream) {
        HtmlConverter.convertToPdf(html, pdfStream, null);
    }

    public static void convertToPdf(String html, OutputStream pdfStream, ConverterProperties converterProperties) {
        HtmlConverter.convertToPdf(html, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter) {
        HtmlConverter.convertToPdf(html, pdfWriter, null);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) {
        DocumentProperties documentProperties = new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.resolveMetaInfo(converterProperties));
        PdfDocument document = HtmlConverter.createCorrectDocument(converterProperties, documentProperties, pdfWriter);
        converterProperties = HtmlConverter.setupCustomConversionProperties(document, converterProperties);
        HtmlConverter.convertToPdf(html, document, converterProperties);
    }

    public static void convertToPdf(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) {
        Document document = HtmlConverter.convertToDocument(html, pdfDocument, converterProperties);
        document.setProperty(135, (Object)new MetaInfoContainer(HtmlConverter.resolveMetaInfo(converterProperties)));
        document.close();
    }

    public static void convertToPdf(File htmlFile, File pdfFile) throws IOException {
        HtmlConverter.convertToPdf(htmlFile, pdfFile, null);
    }

    public static void convertToPdf(File htmlFile, File pdfFile, ConverterProperties converterProperties) throws IOException {
        String baseUri;
        if (converterProperties == null) {
            baseUri = FileUtil.getParentDirectoryUri((File)htmlFile);
            converterProperties = new ConverterProperties().setBaseUri(baseUri);
        } else if (converterProperties.getBaseUri() == null) {
            baseUri = FileUtil.getParentDirectoryUri((File)htmlFile);
            converterProperties = new ConverterProperties(converterProperties).setBaseUri(baseUri);
        }
        try (FileInputStream fileInputStream = new FileInputStream(htmlFile.getAbsolutePath());
             FileOutputStream fileOutputStream = new FileOutputStream(pdfFile.getAbsolutePath());){
            HtmlConverter.convertToPdf((InputStream)fileInputStream, (OutputStream)fileOutputStream, converterProperties);
        }
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfStream, null);
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfDocument, null);
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfDocument(pdfWriter, new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.createPdf2HtmlMetaInfo())));
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        DocumentProperties props = new DocumentProperties().setEventCountingMetaInfo(HtmlConverter.resolveMetaInfo(converterProperties));
        PdfDocument document = HtmlConverter.createCorrectDocument(converterProperties, props, pdfWriter);
        HtmlConverter.convertToPdf(htmlStream, document, converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        converterProperties = HtmlConverter.setupCustomConversionProperties(pdfDocument, converterProperties);
        Document document = HtmlConverter.convertToDocument(htmlStream, pdfDocument, converterProperties);
        IMetaInfo metaInfo = HtmlConverter.resolveMetaInfo(converterProperties);
        document.setProperty(135, (Object)new MetaInfoContainer(metaInfo));
        document.close();
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter) {
        return HtmlConverter.convertToDocument(html, pdfWriter, null);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, pdfWriter, null);
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) {
        return HtmlConverter.convertToDocument(html, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) {
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        converterProperties = HtmlConverter.setupCustomConversionProperties(pdfDocument, converterProperties);
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        converterProperties = HtmlConverter.setupCustomConversionProperties(pdfDocument, converterProperties);
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties.getCharset());
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static List<IElement> convertToElements(String html) {
        return HtmlConverter.convertToElements(html, null);
    }

    public static List<IElement> convertToElements(InputStream htmlStream) throws IOException {
        return HtmlConverter.convertToElements(htmlStream, null);
    }

    public static List<IElement> convertToElements(String html, ConverterProperties converterProperties) {
        converterProperties = HtmlConverter.setupCustomConversionProperties(null, converterProperties);
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, converterProperties);
    }

    public static List<IElement> convertToElements(InputStream htmlStream, ConverterProperties converterProperties) throws IOException {
        converterProperties = HtmlConverter.setupCustomConversionProperties(null, converterProperties);
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties.getCharset());
        return Attacher.attach(doc, converterProperties);
    }

    static IMetaInfo createPdf2HtmlMetaInfo() {
        return new HtmlMetaInfo();
    }

    private static PdfDocument createCorrectDocument(ConverterProperties converterProps, DocumentProperties documentProps, PdfWriter pdfWriter) {
        if (converterProps != null) {
            if (converterProps.getPdfUaConformance() != null && converterProps.getPdfAConformance() != null) {
                throw new Html2PdfException("Using both PDF/A and PDF/UA conformance is currently not supported.");
            }
            if (converterProps.getPdfAConformance() != null) {
                return new PdfADocument(pdfWriter, converterProps.getPdfAConformance(), converterProps.getDocumentOutputIntent(), documentProps);
            }
            if (converterProps.getPdfUaConformance() != null) {
                return new PdfUADocument(pdfWriter, documentProps, new PdfUAConfig(converterProps.getPdfUaConformance(), "Title", "en"));
            }
        }
        return new PdfDocument(pdfWriter, documentProps);
    }

    private static IMetaInfo resolveMetaInfo(ConverterProperties converterProperties) {
        return converterProperties == null ? HtmlConverter.createPdf2HtmlMetaInfo() : converterProperties.getEventMetaInfo();
    }

    private static ConverterProperties setupCustomConversionProperties(PdfDocument document, ConverterProperties properties) {
        boolean needsForcedEmbeddedFonts;
        if (properties == null) {
            properties = new ConverterProperties();
        }
        boolean bl = needsForcedEmbeddedFonts = document instanceof PdfADocument || document instanceof PdfUADocument || properties.getPdfUaConformance() != null || properties.getPdfAConformance() != null;
        if (needsForcedEmbeddedFonts && properties.getFontProvider() == null) {
            BasicFontProvider embeddedFontProvider = new BasicFontProvider(false, true, false);
            properties.setFontProvider((FontProvider)embeddedFontProvider);
        }
        if ((document instanceof PdfUADocument || properties.getPdfUaConformance() != null) && properties.getOutlineHandler() == null) {
            properties.setOutlineHandler(OutlineHandler.createStandardHandler());
        }
        if (properties.getPdfAConformance() != null && "A".equals(properties.getPdfAConformance().getLevel())) {
            document.setTagged();
        }
        return properties;
    }

    private static class HtmlMetaInfo
    implements IMetaInfo {
        private HtmlMetaInfo() {
        }
    }
}

