/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import java.util.Map;

public final class MultiColumnCssApplierUtil {
    private MultiColumnCssApplierUtil() {
    }

    public static void applyMultiCol(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        UnitValue gap;
        Integer columnCount = CssDimensionParsingUtils.parseInteger((String)cssProps.get("column-count"));
        if (columnCount != null) {
            element.setProperty(138, (Object)columnCount);
        }
        float emValue = CssDimensionParsingUtils.parseAbsoluteFontSize((String)cssProps.get("font-size"));
        float remValue = context.getCssContext().getRootFontSize();
        UnitValue width = CssDimensionParsingUtils.parseLengthValueToPt((String)cssProps.get("column-width"), (float)emValue, (float)remValue);
        if (width != null) {
            element.setProperty(142, (Object)Float.valueOf(width.getValue()));
        }
        if (!element.hasProperty(142) && !element.hasProperty(138)) {
            if ("auto".equals(cssProps.get("column-count")) || "auto".equals(cssProps.get("column-width"))) {
                element.setProperty(138, (Object)1);
            } else {
                return;
            }
        }
        if ((gap = CssDimensionParsingUtils.parseLengthValueToPt((String)cssProps.get("column-gap"), (float)emValue, (float)remValue)) != null) {
            element.setProperty(143, (Object)Float.valueOf(gap.getValue()));
        }
        if (!element.hasProperty(143)) {
            element.setProperty(143, (Object)Float.valueOf(CssDimensionParsingUtils.parseRelativeValue((String)"1em", (float)emValue)));
        }
        Border borderFromCssProperties = BorderStyleApplierUtil.getCertainBorder(cssProps.get("column-rule-width"), cssProps.get("column-rule-style"), MultiColumnCssApplierUtil.getColumnGapColorOrDefault(cssProps), emValue, remValue);
        element.setProperty(144, (Object)borderFromCssProperties);
    }

    private static String getColumnGapColorOrDefault(Map<String, String> styles) {
        String borderColor = styles.get("column-rule-color");
        if (borderColor == null || "currentcolor".equals(borderColor)) {
            borderColor = styles.get("color");
        }
        return borderColor;
    }
}

