/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.layout.font.FontCharacteristicsUtils;

public final class FontCharacteristics {
    private boolean isItalic = false;
    private boolean isBold = false;
    private short fontWeight = (short)400;
    private boolean undefined = true;
    private boolean isMonospace = false;

    public FontCharacteristics() {
    }

    public FontCharacteristics(FontCharacteristics other) {
        this();
        this.isItalic = other.isItalic;
        this.isBold = other.isBold;
        this.fontWeight = other.fontWeight;
        this.undefined = other.undefined;
    }

    public FontCharacteristics setFontWeight(short fw) {
        if (fw > 0) {
            this.fontWeight = FontCharacteristicsUtils.normalizeFontWeight(fw);
            this.modified();
        }
        return this;
    }

    public FontCharacteristics setFontWeight(String fw) {
        return this.setFontWeight(FontCharacteristicsUtils.parseFontWeight(fw));
    }

    public FontCharacteristics setBoldFlag(boolean isBold) {
        this.isBold = isBold;
        if (this.isBold) {
            this.modified();
        }
        return this;
    }

    public FontCharacteristics setItalicFlag(boolean isItalic) {
        this.isItalic = isItalic;
        if (this.isItalic) {
            this.modified();
        }
        return this;
    }

    public FontCharacteristics setMonospaceFlag(boolean isMonospace) {
        this.isMonospace = isMonospace;
        if (this.isMonospace) {
            this.modified();
        }
        return this;
    }

    public FontCharacteristics setFontStyle(String fs) {
        if (fs != null && fs.length() > 0) {
            if ("normal".equals(fs = StringNormalizer.normalize((String)fs))) {
                this.isItalic = false;
            } else if ("italic".equals(fs) || "oblique".equals(fs)) {
                this.isItalic = true;
            }
        }
        if (this.isItalic) {
            this.modified();
        }
        return this;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isBold() {
        return this.isBold || this.fontWeight > 500;
    }

    public boolean isMonospace() {
        return this.isMonospace;
    }

    public short getFontWeight() {
        return this.fontWeight;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    private void modified() {
        this.undefined = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontCharacteristics that = (FontCharacteristics)o;
        return this.isItalic == that.isItalic && this.isBold == that.isBold && this.fontWeight == that.fontWeight;
    }

    public int hashCode() {
        int result = this.isItalic ? 1 : 0;
        result = 31 * result + (this.isBold ? 1 : 0);
        result = 31 * result + this.fontWeight;
        return result;
    }
}

