/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.GridContainer;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.ContinuousContainer;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.grid.GridFlow;
import com.itextpdf.layout.properties.grid.GridValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.Grid;
import com.itextpdf.layout.renderer.GridCell;
import com.itextpdf.layout.renderer.GridItemRenderer;
import com.itextpdf.layout.renderer.GridMulticolUtil;
import com.itextpdf.layout.renderer.GridSizer;
import com.itextpdf.layout.renderer.GridTemplateResolver;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;

public class GridContainerRenderer
extends BlockRenderer {
    private float containerHeight = 0.0f;
    private float containerWidth = 0.0f;

    public GridContainerRenderer(GridContainer modelElement) {
        super(modelElement);
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(GridContainerRenderer.class, this.getClass());
        return new GridContainerRenderer((GridContainer)this.modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Grid grid;
        GridLayoutResult layoutResult;
        this.setProperty(140, Boolean.TRUE);
        Rectangle actualBBox = layoutContext.getArea().getBBox().clone();
        Float blockWidth = this.retrieveWidth(actualBBox.getWidth());
        ContinuousContainer.setupContinuousContainerIfNeeded(this);
        this.applyPaddings(actualBBox, false);
        this.applyBorderBox(actualBBox, false);
        this.applyMargins(actualBBox, false);
        this.applyWidth(actualBBox, blockWidth, OverflowPropertyValue.VISIBLE);
        this.containerWidth = actualBBox.getWidth();
        Float blockHeight = this.retrieveHeight();
        if (blockHeight != null && blockHeight.floatValue() < actualBBox.getHeight()) {
            actualBBox.setY(actualBBox.getY() + actualBBox.getHeight() - blockHeight.floatValue());
            actualBBox.setHeight(blockHeight.floatValue());
        }
        if ((layoutResult = this.layoutGrid(layoutContext, actualBBox, grid = GridContainerRenderer.constructGrid(this, new Rectangle(actualBBox.getWidth(), blockHeight == null ? -1.0f : actualBBox.getHeight())))).getOverflowRenderers().isEmpty()) {
            ContinuousContainer continuousContainer = (ContinuousContainer)this.getProperty(141);
            continuousContainer.reApplyProperties(this);
            this.occupiedArea = this.calculateContainerOccupiedArea(layoutContext, true);
            return new LayoutResult(1, this.occupiedArea, null, null);
        }
        if (layoutResult.getSplitRenderers().isEmpty()) {
            IRenderer cause = layoutResult.getCauseOfNothing() == null ? this : layoutResult.getCauseOfNothing();
            return new LayoutResult(3, null, null, this, cause);
        }
        this.occupiedArea = this.calculateContainerOccupiedArea(layoutContext, false);
        return new LayoutResult(2, this.occupiedArea, GridMulticolUtil.createSplitRenderer(layoutResult.getSplitRenderers(), this), this.createOverflowRenderer(layoutResult.getOverflowRenderers()));
    }

    @Override
    public void addChild(IRenderer renderer) {
        renderer.setProperty(99, null);
        renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        renderer.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        renderer.setProperty(89, GridContainerRenderer.determineCollapsingMargins(renderer));
        GridItemRenderer itemRenderer = new GridItemRenderer();
        itemRenderer.setProperty(89, Boolean.FALSE);
        itemRenderer.addChild(renderer);
        super.addChild(itemRenderer);
    }

    private static Boolean determineCollapsingMargins(IRenderer renderer) {
        IRenderer currentRenderer = renderer;
        while (!currentRenderer.getChildRenderers().isEmpty()) {
            if (currentRenderer.getChildRenderers().size() > 1) {
                return Boolean.TRUE;
            }
            currentRenderer = currentRenderer.getChildRenderers().get(0);
        }
        if (currentRenderer instanceof TableRenderer) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private AbstractRenderer createOverflowRenderer(List<IRenderer> children) {
        GridContainerRenderer overflowRenderer = (GridContainerRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.setProperty(146, null);
        overflowRenderer.setProperty(151, null);
        overflowRenderer.setChildRenderers(children);
        ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    private GridLayoutResult layoutGrid(LayoutContext layoutContext, Rectangle actualBBox, Grid grid) {
        GridLayoutResult layoutResult = new GridLayoutResult();
        int notLayoutedRow = grid.getNumberOfRows();
        for (GridCell cell : grid.getUniqueGridCells(Grid.GridOrder.ROW)) {
            LayoutContext cellContext = GridContainerRenderer.getCellLayoutContext(layoutContext, actualBBox, cell);
            Rectangle cellBBox = cellContext.getArea().getBBox();
            IRenderer cellToRender = cell.getValue();
            float itemHeight = ((GridItemRenderer)cellToRender).calculateHeight(cellBBox.getHeight());
            cellToRender.setProperty(27, UnitValue.createPointValue(itemHeight));
            cellBBox.setHeight(cellBBox.getTop() - layoutContext.getArea().getBBox().getBottom()).setY(layoutContext.getArea().getBBox().getY());
            cellToRender.setProperty(87, Boolean.TRUE);
            LayoutResult cellResult = cellToRender.layout(cellContext);
            notLayoutedRow = Math.min(notLayoutedRow, GridContainerRenderer.processLayoutResult(layoutResult, cell, cellResult));
        }
        for (IRenderer overflowRenderer : layoutResult.getOverflowRenderers()) {
            if (overflowRenderer.getProperty(150) == null) continue;
            overflowRenderer.setProperty(150, (Integer)overflowRenderer.getProperty(150) - notLayoutedRow);
            overflowRenderer.setProperty(149, (Integer)overflowRenderer.getProperty(149) - notLayoutedRow);
        }
        return layoutResult;
    }

    private static int processLayoutResult(GridLayoutResult layoutResult, GridCell cell, LayoutResult cellResult) {
        IRenderer overflowRenderer = cellResult.getOverflowRenderer();
        if (cellResult.getStatus() == 3) {
            overflowRenderer.setProperty(148, cell.getColumnStart() + 1);
            overflowRenderer.setProperty(147, cell.getColumnEnd() + 1);
            overflowRenderer.setProperty(150, cell.getRowStart() + 1);
            overflowRenderer.setProperty(149, cell.getRowEnd() + 1);
            layoutResult.getOverflowRenderers().add(overflowRenderer);
            layoutResult.setCauseOfNothing(cellResult.getCauseOfNothing());
            return cell.getRowStart();
        }
        layoutResult.getSplitRenderers().add(cell.getValue());
        if (cellResult.getStatus() == 2) {
            overflowRenderer.setProperty(148, cell.getColumnStart() + 1);
            overflowRenderer.setProperty(147, cell.getColumnEnd() + 1);
            int rowStart = cell.getRowStart() + 1;
            int rowEnd = cell.getRowEnd() + 1;
            layoutResult.getOverflowRenderers().add(overflowRenderer);
            float accumulatedRowSize = 0.0f;
            float layoutedHeight = cellResult.getOccupiedArea().getBBox().getHeight();
            int notLayoutedRow = rowStart - 1;
            for (int i = 0; i < cell.getRowSizes().length && (accumulatedRowSize += cell.getRowSizes()[i]) < layoutedHeight; ++i) {
                ++rowStart;
                ++notLayoutedRow;
            }
            if (rowEnd > rowStart) {
                overflowRenderer.setProperty(150, rowStart);
                overflowRenderer.setProperty(149, rowEnd);
            }
            return notLayoutedRow;
        }
        return Integer.MAX_VALUE;
    }

    private static LayoutContext getCellLayoutContext(LayoutContext layoutContext, Rectangle actualBBox, GridCell cell) {
        LayoutArea tempArea = layoutContext.getArea().clone();
        Rectangle cellLayoutArea = cell.getLayoutArea();
        tempArea.getBBox().setX(actualBBox.getX() + cellLayoutArea.getX());
        tempArea.getBBox().setY(actualBBox.getY() + actualBBox.getHeight() - cellLayoutArea.getHeight() - cellLayoutArea.getY());
        tempArea.getBBox().setWidth(actualBBox.getWidth());
        if (cellLayoutArea.getWidth() > 0.0f) {
            tempArea.getBBox().setWidth(cellLayoutArea.getWidth());
        }
        tempArea.getBBox().setHeight(cellLayoutArea.getHeight());
        return new LayoutContext(tempArea, layoutContext.getMarginsCollapseInfo(), layoutContext.getFloatRendererAreas(), layoutContext.isClippedHeight());
    }

    private LayoutArea calculateContainerOccupiedArea(LayoutContext layoutContext, boolean isFull) {
        LayoutArea area = layoutContext.getArea().clone();
        Rectangle areaBBox = area.getBBox();
        float totalContainerHeight = GridMulticolUtil.updateOccupiedHeight(this.containerHeight, isFull, this);
        if (totalContainerHeight < areaBBox.getHeight() || isFull) {
            Float height = this.retrieveHeight();
            if (height == null) {
                areaBBox.setHeight(totalContainerHeight);
            } else {
                height = Float.valueOf(GridMulticolUtil.updateOccupiedHeight(height.floatValue(), isFull, this));
                areaBBox.setHeight(height.floatValue());
            }
        }
        Rectangle initialBBox = layoutContext.getArea().getBBox();
        areaBBox.setY(initialBBox.getY() + initialBBox.getHeight() - areaBBox.getHeight());
        float totalContainerWidth = GridMulticolUtil.updateOccupiedWidth(this.containerWidth, this);
        areaBBox.setWidth(totalContainerWidth);
        return area;
    }

    private static Grid constructGrid(GridContainerRenderer renderer, Rectangle actualBBox) {
        Float columnGapProp = (Float)renderer.getProperty(143);
        Float rowGapProp = (Float)renderer.getProperty(153);
        float columnGap = columnGapProp == null ? 0.0f : columnGapProp.floatValue();
        float rowGap = rowGapProp == null ? 0.0f : rowGapProp.floatValue();
        GridTemplateResolver rowRepeatResolver = new GridTemplateResolver(actualBBox.getHeight(), rowGap);
        GridTemplateResolver columnRepeatResolver = new GridTemplateResolver(actualBBox.getWidth(), columnGap);
        List<GridValue> templateRows = rowRepeatResolver.resolveTemplate((List)renderer.getProperty(146));
        List<GridValue> templateColumns = columnRepeatResolver.resolveTemplate((List)renderer.getProperty(145));
        GridFlow flow = renderer.getProperty(154) == null ? GridFlow.ROW : (GridFlow)((Object)renderer.getProperty(154));
        for (IRenderer child : renderer.getChildRenderers()) {
            child.setParent(renderer);
        }
        Grid grid = Grid.Builder.forItems(renderer.getChildRenderers()).columns(templateColumns == null ? 0 : templateColumns.size()).rows(templateRows == null ? 0 : templateRows.size()).flow(flow).build();
        if (rowRepeatResolver.isCollapseNullLines()) {
            templateRows = rowRepeatResolver.shrinkTemplatesToFitSize(grid.collapseNullLines(Grid.GridOrder.ROW, rowRepeatResolver.getFixedValuesCount()));
        }
        if (columnRepeatResolver.isCollapseNullLines()) {
            templateColumns = columnRepeatResolver.shrinkTemplatesToFitSize(grid.collapseNullLines(Grid.GridOrder.COLUMN, columnRepeatResolver.getFixedValuesCount()));
        }
        GridValue columnAutoWidth = (GridValue)renderer.getProperty(152);
        GridValue rowAutoHeight = (GridValue)renderer.getProperty(151);
        GridSizer gridSizer = new GridSizer(grid, templateColumns, templateRows, columnAutoWidth, rowAutoHeight, columnGap, rowGap, actualBBox);
        gridSizer.sizeGrid();
        renderer.containerHeight = gridSizer.getContainerHeight();
        return grid;
    }

    private static final class GridLayoutResult {
        private final List<IRenderer> splitRenderers = new ArrayList<IRenderer>();
        private final List<IRenderer> overflowRenderers = new ArrayList<IRenderer>();
        private IRenderer causeOfNothing;

        public List<IRenderer> getSplitRenderers() {
            return this.splitRenderers;
        }

        public List<IRenderer> getOverflowRenderers() {
            return this.overflowRenderers;
        }

        public void setCauseOfNothing(IRenderer causeOfNothing) {
            this.causeOfNothing = causeOfNothing;
        }

        public IRenderer getCauseOfNothing() {
            return this.causeOfNothing;
        }
    }
}

