/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.ILombokPluginHook;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class LombokPlugin
extends BasePlugin {
    public static final String PRO_BUILDER = "@Builder";
    public static final String PRO_ALL_ARGS_CONSTRUCTOR = "@AllArgsConstructor";
    public static final String PRO_NO_ARGS_CONSTRUCTOR = "@NoArgsConstructor";
    private boolean hasBuilder;
    private boolean hasAllArgsConstructor;
    private boolean hasNoArgsConstructor;

    @Override
    public boolean validate(List<String> warnings) {
        Properties properties = this.getProperties();
        String builder = properties.getProperty(PRO_BUILDER);
        String allArgsConstructor = properties.getProperty(PRO_ALL_ARGS_CONSTRUCTOR);
        String noArgsConstructor = properties.getProperty(PRO_NO_ARGS_CONSTRUCTOR);
        this.hasBuilder = builder == null ? false : StringUtility.isTrue((String)builder);
        this.hasAllArgsConstructor = allArgsConstructor == null ? false : StringUtility.isTrue((String)allArgsConstructor);
        this.hasNoArgsConstructor = noArgsConstructor == null ? false : StringUtility.isTrue((String)noArgsConstructor);
        return super.validate(warnings);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, EnumLombokAnnotations.DATA);
        if (topLevelClass.getSuperClass() != null) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.EQUALS_AND_HASH_CODE_CALL_SUPER);
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.TO_STRING_CALL_SUPER);
        }
        List<IntrospectedColumn> columns = IntrospectedTableTools.getModelBaseRecordClomns(introspectedTable);
        if (this.hasBuilder && PluginTools.getHook(ILombokPluginHook.class).modelBaseRecordBuilderClassGenerated(topLevelClass, columns, introspectedTable)) {
            if (introspectedTable.getRules().generateRecordWithBLOBsClass() || introspectedTable.getRules().generatePrimaryKeyClass() || topLevelClass.getSuperClass() != null) {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.SUPER_BUILDER);
            } else {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.BUILDER);
            }
        }
        if (this.hasNoArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.NO_ARGS_CONSTRUCTOR);
        }
        if (this.hasAllArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.ALL_ARGS_CONSTRUCTOR);
        }
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, EnumLombokAnnotations.DATA);
        if (topLevelClass.getSuperClass() != null) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.EQUALS_AND_HASH_CODE_CALL_SUPER);
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.TO_STRING_CALL_SUPER);
        }
        List columns = introspectedTable.getPrimaryKeyColumns();
        if (this.hasBuilder && PluginTools.getHook(ILombokPluginHook.class).modelPrimaryKeyBuilderClassGenerated(topLevelClass, columns, introspectedTable)) {
            if (introspectedTable.getRules().generateRecordWithBLOBsClass() || introspectedTable.getRules().generateBaseRecordClass() || topLevelClass.getSuperClass() != null) {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.SUPER_BUILDER);
            } else {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.BUILDER);
            }
        }
        if (this.hasNoArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.NO_ARGS_CONSTRUCTOR);
        }
        if (this.hasAllArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.ALL_ARGS_CONSTRUCTOR);
        }
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, EnumLombokAnnotations.DATA);
        if (topLevelClass.getSuperClass() != null) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.EQUALS_AND_HASH_CODE_CALL_SUPER);
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.TO_STRING_CALL_SUPER);
        }
        List columns = introspectedTable.getBLOBColumns();
        if (this.hasBuilder && PluginTools.getHook(ILombokPluginHook.class).modelRecordWithBLOBsBuilderClassGenerated(topLevelClass, columns, introspectedTable)) {
            if (introspectedTable.getRules().generateBaseRecordClass() || introspectedTable.getRules().generatePrimaryKeyClass() || topLevelClass.getSuperClass() != null) {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.SUPER_BUILDER);
            } else {
                this.addAnnotations(topLevelClass, EnumLombokAnnotations.BUILDER);
            }
        }
        if (this.hasNoArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.NO_ARGS_CONSTRUCTOR);
        }
        if (this.hasAllArgsConstructor) {
            this.addAnnotations(topLevelClass, EnumLombokAnnotations.ALL_ARGS_CONSTRUCTOR);
        }
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    private void addAnnotations(TopLevelClass topLevelClass, EnumLombokAnnotations annotations) {
        topLevelClass.addImportedType(annotations.getClazz());
        topLevelClass.addAnnotation(annotations.getAnnotation());
    }

    public static enum EnumLombokAnnotations {
        DATA("@Data", "lombok.Data"),
        BUILDER("@Builder", "lombok.Builder"),
        SUPER_BUILDER("@SuperBuilder", "lombok.experimental.SuperBuilder"),
        ALL_ARGS_CONSTRUCTOR("@AllArgsConstructor", "lombok.AllArgsConstructor"),
        NO_ARGS_CONSTRUCTOR("@NoArgsConstructor", "lombok.NoArgsConstructor"),
        EQUALS_AND_HASH_CODE_CALL_SUPER("@EqualsAndHashCode(callSuper = true)", "lombok.EqualsAndHashCode"),
        SETTER("@Setter", "lombok.Setter"),
        ACCESSORS_FLUENT_TRUE("@Accessors(fluent = true)", "lombok.experimental.Accessors"),
        TO_STRING("@ToString", "lombok.ToString"),
        TO_STRING_CALL_SUPER("@ToString(callSuper = true)", "lombok.ToString");

        private final String annotation;
        private final String clazz;

        private EnumLombokAnnotations(String annotation, String clazz) {
            this.annotation = annotation;
            this.clazz = clazz;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public String getClazz() {
            return this.clazz;
        }
    }
}

