/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils.enhanced;

import java.util.Iterator;
import java.util.Set;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.internal.util.StringUtility;

public class InnerInterface
extends Interface {
    public InnerInterface(FullyQualifiedJavaType type) {
        super(type);
    }

    public InnerInterface(String type) {
        super(type);
    }

    public String getFormattedContent(int indentLevel, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        for (String commentLine : this.getFileCommentLines()) {
            sb.append(commentLine);
            OutputUtilities.newLine((StringBuilder)sb);
        }
        if (StringUtility.stringHasValue((String)this.getType().getPackageName())) {
            sb.append("package ");
            sb.append(this.getType().getPackageName());
            sb.append(';');
            OutputUtilities.newLine((StringBuilder)sb);
            OutputUtilities.newLine((StringBuilder)sb);
        }
        for (Object staticImport : this.getStaticImports()) {
            sb.append("import static ");
            sb.append((String)staticImport);
            sb.append(';');
            OutputUtilities.newLine((StringBuilder)sb);
        }
        if (this.getStaticImports().size() > 0) {
            OutputUtilities.newLine((StringBuilder)sb);
        }
        Set importStrings = OutputUtilities.calculateImports((Set)this.getImportedTypes());
        for (Object importString : importStrings) {
            sb.append((String)importString);
            OutputUtilities.newLine((StringBuilder)sb);
        }
        if (importStrings.size() > 0) {
            OutputUtilities.newLine((StringBuilder)sb);
        }
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        OutputUtilities.javaIndent((StringBuilder)sb, (int)indentLevel);
        sb.append(this.getVisibility().getValue());
        if (this.isFinal()) {
            sb.append("final ");
        }
        sb.append("interface ");
        sb.append(this.getType().getShortName());
        if (this.getSuperInterfaceTypes().size() > 0) {
            sb.append(" extends ");
            boolean comma = false;
            for (FullyQualifiedJavaType fqjt : this.getSuperInterfaceTypes()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(JavaDomUtils.calculateTypeName((CompilationUnit)this, (FullyQualifiedJavaType)fqjt));
            }
        }
        sb.append(" {");
        ++indentLevel;
        Iterator mtdIter = this.getMethods().iterator();
        while (mtdIter.hasNext()) {
            OutputUtilities.newLine((StringBuilder)sb);
            Method method = (Method)mtdIter.next();
            sb.append(method.getFormattedContent(indentLevel, true, (CompilationUnit)this));
            if (!mtdIter.hasNext()) continue;
            OutputUtilities.newLine((StringBuilder)sb);
        }
        OutputUtilities.newLine((StringBuilder)sb);
        OutputUtilities.javaIndent((StringBuilder)sb, (int)(--indentLevel));
        sb.append('}');
        return sb.toString();
    }
}

