/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.Counter;
import com.jamonapi.FrequencyDistImp;
import com.jamonapi.utils.LocaleContext;
import java.text.DecimalFormat;

class FrequencyDistBase
extends FrequencyDistImp {
    private ActivityStats activityStats;
    private double allActiveTotal;
    private double primaryActiveTotal;
    private double thisActiveTotal;

    public FrequencyDistBase(String displayHeader, double endValue, String name) {
        this.displayHeader = displayHeader;
        this.endValue = endValue;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(double value) {
        super.addValue(value);
        if (this.trackActivity) {
            Counter counter = this.activityStats.thisActive;
            synchronized (counter) {
                this.thisActiveTotal += this.activityStats.thisActive.count;
            }
            counter = this.activityStats.primaryActive;
            synchronized (counter) {
                this.primaryActiveTotal += this.activityStats.primaryActive.count;
            }
            counter = this.activityStats.allActive;
            synchronized (counter) {
                this.allActiveTotal += this.activityStats.allActive.count;
            }
        }
    }

    private double avg(double value) {
        if (this.hits == 0.0) {
            return 0.0;
        }
        return value / this.hits;
    }

    public synchronized void reset() {
        super.reset();
        this.thisActiveTotal = 0.0;
        this.primaryActiveTotal = 0.0;
        this.allActiveTotal = 0.0;
    }

    public void setActivityStats(ActivityStats activityStats) {
        this.activityStats = activityStats;
    }

    private ActivityStats getActivityStats() {
        return this.activityStats;
    }

    public synchronized double getAvgActive() {
        return this.avg(this.thisActiveTotal);
    }

    public synchronized double getAvgGlobalActive() {
        return this.avg(this.allActiveTotal);
    }

    public synchronized double getAvgPrimaryActive() {
        return this.avg(this.primaryActiveTotal);
    }

    private String format(double value) {
        DecimalFormat decimalFormat = LocaleContext.getFloatingPointFormatter();
        return decimalFormat.format(value);
    }

    public String toString() {
        if (this.hits == 0.0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.format(this.getHits()));
        buff.append("/");
        buff.append(this.format(this.getAvg()));
        buff.append(" (");
        buff.append(this.format(this.getAvgActive())).append("/");
        buff.append(this.format(this.getAvgPrimaryActive())).append("/");
        buff.append(this.format(this.getAvgGlobalActive())).append(")");
        return buff.toString();
    }
}

