/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.Mon;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorImp;
import com.jamonapi.NullRange;
import com.jamonapi.Range;
import com.jamonapi.utils.Misc;
import java.util.ArrayList;
import java.util.Date;

public class MonitorComposite
extends Monitor {
    private MonitorImp[] monitors;
    private int numRows;
    private static Range NULL_RANGE = new NullRange();
    private static int TYPICAL_NUM_CHILDREN = 200;

    public MonitorComposite(Monitor[] monitors) {
        this.monitors = (MonitorImp[])monitors;
        this.numRows = monitors == null ? 0 : monitors.length;
    }

    MonitorComposite() {
        this(null);
    }

    public Monitor[] getMonitors() {
        return this.monitors;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String[] getBasicHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getBasicHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    public String[] getHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    public String[] getDisplayHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getDisplayHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    private int getBasicHeaderSize() {
        return this.getBasicHeader() == null ? 0 : this.getBasicHeader().length;
    }

    public Object[][] getData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getRowData(this.monitors[i]);
        }
        return data;
    }

    public Object[][] getBasicData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getBasicRowData(this.monitors[i]);
        }
        return data;
    }

    public Object[][] getDisplayData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getRowDisplayData(this.monitors[i]);
        }
        return data;
    }

    public String getReport() {
        return this.getReport(0, "asc");
    }

    public String getReport(int sortCol, String sortOrder) {
        int i;
        if (!this.hasData()) {
            return "";
        }
        String[] header = this.getBasicHeader();
        Object[][] data = Misc.sort(this.getBasicData(), sortCol, sortOrder);
        int rows = data.length;
        int cols = header.length;
        StringBuffer html = new StringBuffer(100000);
        html.append("\n<table border='1' rules='all'>\n");
        for (i = 0; i < cols; ++i) {
            html.append("<th>" + header[i] + "</th>");
        }
        html.append("<th>" + header[0] + "</th>");
        html.append("\n");
        for (i = 0; i < rows; ++i) {
            html.append("<tr>");
            for (int j = 0; j < cols; ++j) {
                html.append("<td>" + data[i][j] + "</td>");
            }
            html.append("<td>" + data[i][0] + "</td>");
            html.append("</tr>\n");
        }
        html.append("</table>");
        return html.toString();
    }

    public boolean hasData() {
        return this.getNumRows() != 0;
    }

    private Object[] getRowData(MonitorImp mon) {
        ArrayList row = new ArrayList(TYPICAL_NUM_CHILDREN);
        mon.getRowData(row);
        return row.toArray();
    }

    private Object[] getBasicRowData(MonitorImp mon) {
        ArrayList row = new ArrayList();
        mon.getBasicRowData(row);
        return row.toArray();
    }

    private Object[] getRowDisplayData(MonitorImp mon) {
        ArrayList row = new ArrayList(TYPICAL_NUM_CHILDREN);
        mon.getRowDisplayData(row);
        return row.toArray();
    }

    public void reset() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].reset();
        }
    }

    public Monitor add(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].add(value);
        }
        return this;
    }

    public void disable() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].disable();
        }
    }

    public void enable() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].enable();
        }
    }

    public double getActive() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getActive();
        }
        return value;
    }

    public double getAvg() {
        double hits = this.getHits();
        double total = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            total += this.monitors[i].getTotal();
        }
        if (hits == 0.0) {
            return 0.0;
        }
        return total / hits;
    }

    public double getAvgActive() {
        double weightedActive = 0.0;
        double totalHits = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double hits = this.monitors[i].getHits();
            weightedActive = hits * this.monitors[i].getAvgActive();
            totalHits += hits;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedActive / totalHits;
    }

    public Date getFirstAccess() {
        Date firstAccess = null;
        for (int i = 0; i < this.numRows; ++i) {
            Date thisDate = this.monitors[i].getFirstAccess();
            if (firstAccess != null && thisDate.compareTo(firstAccess) >= 0) continue;
            firstAccess = thisDate;
        }
        return firstAccess;
    }

    public double getHits() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getHits();
        }
        return value;
    }

    public MonKey getMonKey() {
        if (!this.hasData()) {
            return null;
        }
        return this.getFirstMon().getMonKey();
    }

    public Date getLastAccess() {
        Date lastAccess = null;
        for (int i = 0; i < this.numRows; ++i) {
            Date thisDate = this.monitors[i].getLastAccess();
            if (lastAccess != null && thisDate.compareTo(lastAccess) <= 0) continue;
            lastAccess = thisDate;
        }
        return lastAccess;
    }

    public double getLastValue() {
        Date date = this.getLastAccess();
        for (int i = 0; i < this.numRows; ++i) {
            if (date.compareTo(this.monitors[i].getLastAccess()) < 0) continue;
            return this.monitors[i].getLastValue();
        }
        return 0.0;
    }

    public double getMax() {
        double max = Mon.MAX;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMax = this.monitors[i].getMax();
            if (!(thisMax > max)) continue;
            max = thisMax;
        }
        return max;
    }

    public double getMaxActive() {
        double max = Mon.MAX;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMax = this.monitors[i].getMaxActive();
            if (!(thisMax > max)) continue;
            max = thisMax;
        }
        return max;
    }

    public double getMin() {
        double min = Mon.MIN;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMin = this.monitors[i].getMin();
            if (!(thisMin < min)) continue;
            min = thisMin;
        }
        return min;
    }

    public Range getRange() {
        return NULL_RANGE;
    }

    public double getStdDev() {
        double weightedStdDev = 0.0;
        double totalHits = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double hits = this.monitors[i].getHits();
            weightedStdDev = hits * this.monitors[i].getStdDev();
            totalHits += hits;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedStdDev / totalHits;
    }

    public double getTotal() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getTotal();
        }
        return value;
    }

    public boolean isEnabled() {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.monitors[i].isEnabled()) continue;
            return false;
        }
        return true;
    }

    public boolean isPrimary() {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.monitors[i].isPrimary()) continue;
            return false;
        }
        return true;
    }

    public void setActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setActive(0.0);
        }
    }

    public void setFirstAccess(Date date) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setFirstAccess(date);
        }
    }

    public void setHits(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setHits(value);
        }
    }

    public void setLastAccess(Date date) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setLastAccess(date);
        }
    }

    public void setLastValue(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setLastValue(value);
        }
    }

    public void setMax(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMax(value);
        }
    }

    public void setMaxActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMaxActive(value);
        }
    }

    public void setMin(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMin(value);
        }
    }

    public void setPrimary(boolean isPrimary) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setPrimary(isPrimary);
        }
    }

    public void setTotal(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setTotal(value);
        }
    }

    public void setTotalActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setTotalActive(value);
        }
    }

    public Monitor start() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].start();
        }
        return this;
    }

    public Monitor stop() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].stop();
        }
        return this;
    }

    private MonitorImp getFirstMon() {
        return this.monitors[0];
    }
}

