/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.FactoryDisabled;
import com.jamonapi.FactoryEnabled;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.RangeHolder;
import java.util.Map;

public class MonitorFactory {
    private static MonitorFactoryInterface factory;
    private static MonitorFactoryInterface enabledFactory;
    private static MonitorFactoryInterface disabledFactory;
    private static MonitorFactoryInterface debugFactory;

    public static MonitorFactoryInterface getFactory() {
        return factory;
    }

    public static MonitorFactoryInterface getDebugFactory() {
        if (MonitorFactory.isEnabled()) {
            return debugFactory;
        }
        return disabledFactory;
    }

    public static Monitor add(String label, String units, double value) {
        return factory.add(label, units, value);
    }

    public static Monitor start(String label) {
        return factory.start(label);
    }

    public static Monitor start() {
        return factory.start();
    }

    public static Monitor startPrimary(String label) {
        return factory.startPrimary(label);
    }

    public static Monitor getMonitor(String label, String units) {
        return factory.getMonitor(label, units);
    }

    public static Monitor getTimeMonitor(String label) {
        return factory.getTimeMonitor(label);
    }

    public static boolean exists(String label, String units) {
        return factory.exists(label, units);
    }

    public static MonitorComposite getComposite(String units) {
        return factory.getComposite(units);
    }

    public static int getNumRows() {
        return factory.getNumRows();
    }

    public static String[] getRangeHeader() {
        return factory.getRangeHeader();
    }

    public static Object[][] getRangeNames() {
        return factory.getRangeNames();
    }

    public static MonitorComposite getRootMonitor() {
        return factory.getRootMonitor();
    }

    public static String getVersion() {
        return factory.getVersion();
    }

    public static void remove(String label, String units) {
        factory.remove(label, units);
    }

    public static void setMap(Map map) {
        factory.setMap(map);
    }

    public static void setRangeDefault(String key, RangeHolder rangeHolder) {
        factory.setRangeDefault(key, rangeHolder);
    }

    public static void setEnabled(boolean enable) {
        factory = enable ? enabledFactory : disabledFactory;
    }

    public static void setDebugEnabled(boolean enable) {
        debugFactory = enable ? enabledFactory : disabledFactory;
    }

    public static void enable() {
        MonitorFactory.setEnabled(true);
    }

    public static void disable() {
        MonitorFactory.setEnabled(false);
    }

    public static boolean isEnabled() {
        return factory == enabledFactory;
    }

    public static boolean isDebugEnabled() {
        return debugFactory == enabledFactory;
    }

    public static void reset() {
        if (MonitorFactory.isEnabled()) {
            enabledFactory = factory = new FactoryEnabled();
        }
    }

    public static void setJAMonAdminPage(String JAMonAdminPage) {
    }

    public static MonitorFactoryInterface getDebugFactory(int debugPriorityLevel) {
        return MonitorFactory.getDebugFactory();
    }

    public static String[] getHeader() {
        return factory.getRootMonitor().getBasicHeader();
    }

    public static Object[][] getData() {
        return factory.getRootMonitor().getBasicData();
    }

    public static String getReport() {
        return factory.getRootMonitor().getReport();
    }

    public static String getReport(String units) {
        return MonitorFactory.getComposite(units).getReport();
    }

    public static void setDebugPriorityLevel(int debugPriorityLevel) {
    }

    private static RangeHolder getTestHolder() {
        RangeHolder rh = new RangeHolder();
        rh.add("10_display", 10.0);
        rh.add("20_display", 20.0);
        rh.add("30_display", 30.0);
        rh.add("40_display", 40.0);
        rh.add("50_display", 50.0);
        rh.add("60_display", 60.0);
        rh.add("70_display", 70.0);
        rh.add("80_display", 80.0);
        rh.add("90_display", 90.0);
        rh.add("100_display", 100.0);
        rh.add("110_display", 110.0);
        rh.add("120_display", 120.0);
        rh.add("130_display", 130.0);
        rh.add("140_display", 140.0);
        rh.add("150_display", 150.0);
        return rh;
    }

    public static void main(String[] args) {
        int i;
        Monitor timer = MonitorFactory.start("totaltime");
        for (int i2 = 1; i2 <= 10; ++i2) {
            System.out.println(MonitorFactory.add("NIC.bytes.sent", "bytes", i2 * 1000));
            MonitorFactory.add("negativetest", "neg", -1000.0 * (double)i2);
        }
        System.out.println("");
        Monitor m = null;
        m = MonitorFactory.start("purchasesTimeTestNoRange");
        for (i = 1; i <= 1000000; ++i) {
            MonitorFactory.add("purchasesNoRange", "dollars", 1000.0);
        }
        System.out.println("purchasesTimeTestNoRange=" + m.stop().getTotal());
        m = MonitorFactory.start("testTimerTimeTest");
        for (i = 1; i <= 1000000; ++i) {
            MonitorFactory.start("testTimer").stop();
        }
        System.out.println("testTimerTimeTest=" + m.stop().getTotal());
        for (i = -5; i <= 20; ++i) {
            MonitorFactory.add("purchases", "dollars", i * 50);
        }
        System.out.println("");
        System.out.println(MonitorFactory.add("NIC.bytes.received", "bytes", 250.0));
        System.out.println(MonitorFactory.add("NIC.bytes.received", "bytes", 250.0));
        timer.stop();
        for (i = -5; i < 25; ++i) {
            MonitorFactory.add("timetest", "ms.", i * 5);
        }
        System.out.println(MonitorFactory.getMonitor("purchases", "dollars").getHits());
        System.out.println(MonitorFactory.getTimeMonitor("testtimer").getHits());
        System.out.println("Total time=" + timer.getTotal());
        MonitorFactory.reset();
        RangeHolder rh = new RangeHolder();
        MonitorFactory.setRangeDefault("dollars", MonitorFactory.getTestHolder());
        m = MonitorFactory.start("purchasesTimeTestRange");
        for (int i3 = 1; i3 <= 1000000; ++i3) {
            MonitorFactory.add("purchasesRange", "dollars", 1000.0);
        }
        System.out.println("purchasesTimeTestRange=" + m.stop().getTotal());
        Object[][] data = null;
        MonitorFactory.setRangeDefault("bytes", MonitorFactory.getTestHolder());
        MonitorFactory.setRangeDefault("cents", MonitorFactory.getTestHolder());
        MonitorFactory.setRangeDefault("minutes", MonitorFactory.getTestHolder());
        MonitorFactory.setRangeDefault("MB", MonitorFactory.getTestHolder());
        MonitorFactory.setRangeDefault("KB", MonitorFactory.getTestHolder());
        MonitorFactory.setRangeDefault("points", MonitorFactory.getTestHolder());
        String[] header = MonitorFactory.getComposite("ms.").getHeader();
        data = MonitorFactory.getComposite("ms.").getData();
        header = MonitorFactory.getComposite("ms.").getBasicHeader();
        data = MonitorFactory.getComposite("ms.").getBasicData();
        header = MonitorFactory.getComposite("ms.").getDisplayHeader();
        data = MonitorFactory.getComposite("ms.").getDisplayData();
        MonitorFactory.getComposite("ms.").disable();
        header = MonitorFactory.getComposite("ms.").getHeader();
        data = MonitorFactory.getComposite("ms.").getData();
        System.out.println("JAMon Version=" + MonitorFactory.getVersion());
    }

    static {
        debugFactory = enabledFactory = new FactoryEnabled();
        factory = enabledFactory;
        disabledFactory = new FactoryDisabled(enabledFactory);
    }
}

