/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.event.impl;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.event.BaseFlowEventListener;
import com.jd.easyflow.flow.engine.event.FlowEvent;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.util.FlowUtil;
import com.jd.easyflow.flow.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptFlowListener
extends BaseFlowEventListener {
    private static final Logger logger = LoggerFactory.getLogger(InterruptFlowListener.class);
    private static final Pair<String, Integer>[] DEFAULT_ACCEPTED_EVENTS = new Pair[]{Pair.of("NODE_END", 10000)};

    public InterruptFlowListener() {
        this.acceptedEvents = DEFAULT_ACCEPTED_EVENTS;
    }

    @Override
    public void on(FlowEvent event) {
        switch (event.getType()) {
            case "NODE_END": {
                NodeContext nodeContext = (NodeContext)event.getData();
                FlowContext context = event.getContext();
                Boolean interrupt = (Boolean)FlowUtil.nodeProperty("interrupt", nodeContext, context);
                if (interrupt == null) {
                    String flowInterruptExp;
                    String interruptExp = (String)FlowUtil.nodeProperty("interruptExp", nodeContext, context);
                    if (interruptExp != null) {
                        interrupt = (Boolean)context.getElEvaluator().eval(interruptExp, nodeContext, context, null);
                    }
                    if (interrupt == null && (flowInterruptExp = (String)context.getFlow().getProperty("interruptExp")) != null) {
                        interrupt = (Boolean)context.getElEvaluator().eval(flowInterruptExp, nodeContext, context, null);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Flow interrupt result:" + interrupt);
                }
                if (!Boolean.TRUE.equals(interrupt)) break;
                context.setInterrupted();
                break;
            }
        }
    }
}

