/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.filter;

import com.jd.easyflow.flow.engine.FlowEngine;
import com.jd.easyflow.flow.engine.FlowParam;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.filter.FilterChainImpl;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class FlowEngineFilterManager {
    protected List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> filters;
    protected List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> innerFilters;
    protected List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> outerFilters;

    public void init(InitContext initContext, FlowEngine flowEngine) {
        if (this.filters != null) {
            this.filters.forEach(filter -> filter.init(initContext, flowEngine));
            this.refreshFilters();
        }
    }

    public boolean noOuterFilter() {
        return this.outerFilters == null || this.outerFilters.size() == 0;
    }

    public FlowResult doOuterFilter(Pair<FlowParam, FlowEngine> p, Function<Pair<FlowParam, FlowEngine>, FlowResult> outerInvoker) {
        FilterChainImpl<Pair<FlowParam, FlowEngine>, FlowResult> chain = new FilterChainImpl<Pair<FlowParam, FlowEngine>, FlowResult>(this.outerFilters, outerInvoker);
        return (FlowResult)chain.doFilter(p);
    }

    public boolean noInnerFilter() {
        return this.innerFilters == null || this.innerFilters.size() == 0;
    }

    public FlowResult doInnerFilter(Pair<FlowParam, FlowEngine> p, Function<Pair<FlowParam, FlowEngine>, FlowResult> innerInvoker) {
        FilterChainImpl<Pair<FlowParam, FlowEngine>, FlowResult> chain = new FilterChainImpl<Pair<FlowParam, FlowEngine>, FlowResult>(this.innerFilters, innerInvoker);
        return (FlowResult)chain.doFilter(p);
    }

    public List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> filters) {
        this.filters = filters;
        this.refreshFilters();
    }

    private void refreshFilters() {
        if (this.filters == null) {
            this.outerFilters = null;
            this.innerFilters = null;
        } else {
            this.innerFilters = new ArrayList<Filter<Pair<FlowParam, FlowEngine>, FlowResult>>();
            this.outerFilters = new ArrayList<Filter<Pair<FlowParam, FlowEngine>, FlowResult>>();
            for (Filter<Pair<FlowParam, FlowEngine>, FlowResult> filter : this.filters) {
                int pos;
                int filterOrder = filter.getOrder();
                if (filterOrder < 0) {
                    for (pos = 0; pos < this.innerFilters.size() && this.innerFilters.get(pos).getOrder() >= filterOrder; ++pos) {
                    }
                    this.innerFilters.add(pos, filter);
                    continue;
                }
                while (pos < this.outerFilters.size() && this.outerFilters.get(pos).getOrder() >= filterOrder) {
                    ++pos;
                }
                this.outerFilters.add(pos, filter);
            }
        }
    }

    public List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> getInnerFilters() {
        return this.innerFilters;
    }

    public List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> getOuterFilters() {
        return this.outerFilters;
    }
}

