/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.action.compensate.CompensateHelper;
import com.jd.easyflow.flow.model.action.compensate.CompensateNodeFilter;
import com.jd.easyflow.flow.model.action.compensate.CompensateNodePreHandlerFilter;
import com.jd.easyflow.flow.util.Pair;
import com.jd.easyflow.flow.util.Triple;
import java.util.ArrayList;
import java.util.List;

public class CompensateNodeAction
implements NodeAction {
    @Override
    public <T> T execute(NodeContext nodeContext, FlowContext context) {
        CompensateHelper.compensate(context);
        return null;
    }

    @Override
    public void init(InitContext initContext, Object flowNode) {
        boolean recordHistory;
        boolean bl = recordHistory = !Boolean.FALSE.equals(initContext.getFlow().getProperty("flow.recordHistory"));
        if (!recordHistory) {
            throw new FlowException("CompensateNodeAction must record history");
        }
        this.initNodeFilter(initContext, flowNode);
        this.initNodePreHandlerFilter(initContext, flowNode);
    }

    private void initNodeFilter(InitContext initContext, Object flowNode) {
        List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> filters = initContext.getFlow().getFilterManager().getNodeFilters();
        boolean contains = false;
        if (filters == null) {
            filters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            initContext.getFlow().getFilterManager().setNodeFilters(filters);
        }
        for (Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> filter : filters) {
            if (!(filter instanceof CompensateNodeFilter)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            filters.add(0, new CompensateNodeFilter(Integer.MAX_VALUE));
            initContext.getFlow().getFilterManager().setNodeFilters(filters);
        }
    }

    private void initNodePreHandlerFilter(InitContext initContext, Object flowNode) {
        List<Filter<Pair<NodeContext, FlowContext>, Boolean>> nodePreHandlerFilters = initContext.getFlow().getFilterManager().getNodePreHandlerFilters();
        boolean contains = false;
        if (nodePreHandlerFilters == null) {
            nodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
            initContext.getFlow().getFilterManager().setNodePreHandlerFilters(nodePreHandlerFilters);
        }
        for (Filter<Pair<NodeContext, FlowContext>, Boolean> filter : nodePreHandlerFilters) {
            if (!(filter instanceof CompensateNodePreHandlerFilter)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            nodePreHandlerFilters.add(0, new CompensateNodePreHandlerFilter(Integer.MAX_VALUE));
            initContext.getFlow().getFilterManager().setNodePreHandlerFilters(nodePreHandlerFilters);
        }
    }
}

